% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gen_process.cpp, src/gen_process.h
\name{gen_arma}
\alias{gen_arma}
\title{Generate Autoregressive Order \eqn{p} - Moving Average Order \eqn{q} (ARMA(\eqn{p},\eqn{q})) Model}
\usage{
gen_arma(N, ar, ma, sigma2 = 1.5, n_start = 0L)
}
\arguments{
\item{N}{An \code{integer} for signal length.}

\item{ar}{A \code{vec} that contains the AR coefficients.}

\item{ma}{A \code{vec} that contains the MA coefficients.}

\item{sigma2}{A \code{double} that contains process variance.}

\item{n_start}{An \code{unsigned int} that indicates the amount of observations to be used for the burn in period.}
}
\value{
A \code{vec} that contains the generated observations.
}
\description{
Generate an ARMA(\eqn{p},\eqn{q}) process with supplied vector of Autoregressive Coefficients (\eqn{\phi}), Moving Average Coefficients (\eqn{\theta}), and \eqn{\sigma^2}.
}
\details{
For \code{\link[=gen_ar1]{AR(1)}}, \code{\link[=gen_ma1]{MA(1)}}, and \code{\link[=gen_arma11]{ARMA(1,1)}} please use their functions if speed is important
as this function is designed to generate generic ARMA processes.
}
\section{Process Definition}{

The Autoregressive order \eqn{p} and Moving Average order \eqn{q} (ARMA(\eqn{p},\eqn{q})) process with non-zero parameters \eqn{\phi_i \in (-1,+1)}{phi[i] in (-1,1)} for the AR components,
 \eqn{\theta_j \in (-1,+1)}{theta[j] in (-1,+1)} for the MA components, and \eqn{\sigma^2 \in {\rm I\!R}^{+}}{sigma^2 in R^{+}}.
This process is defined as:

\deqn{{X_t} = \sum\limits_{i = 1}^p {{\phi _i}{X_{t - i}}}  + \sum\limits_{i = 1}^q {{\theta _i}{\varepsilon _{t - i}}}  + {\varepsilon _t}}{X[t] = sum(phi[p]*X[t-1]) + sum(theta[q]*W[t-1]) + W[t]}  
 where
  \deqn{{\varepsilon_t}\mathop  \sim \limits^{iid} N\left( {0,\sigma^2} \right)}{W[t] ~ N(0,sigma^2) iid}
}

\section{Generation Algorithm}{
 
The innovations are generated from a normal distribution.
The \eqn{\sigma^2} parameter is indeed a variance parameter. 
This differs from R's use of the standard deviation, \eqn{\sigma}.
}

\keyword{internal}
