% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{MAPE}
\alias{MAPE}
\title{Median Absolute Prediction Error}
\usage{
MAPE(model, Xt, start = 0.8, plot = TRUE)
}
\arguments{
\item{model}{A time series model.}

\item{Xt}{A \code{vector} of time series data.}

\item{start}{A \code{numeric} indicating the starting proportion of the data
that is used for prediction.}

\item{plot}{A \code{boolean} indicating whether a model accuracy plot based
on MAPE is returned or not.}
}
\value{
The MAPE calculated based on one-step ahead prediction and reforecasting
is returned along with its standard deviation.
}
\description{
This function calculates Median Absolute Prediction Error (MAPE), which assesses 
the prediction performance with respect to point forecasts of a given model. 
It is calculated based on one-step ahead prediction and reforecasting.
}
\author{
Stéphane Guerrier and Yuming Zhang
}
