% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/process_to_wv.cpp, src/process_to_wv.h
\name{ma1_to_wv}
\alias{ma1_to_wv}
\title{Moving Average Order 1 (MA(1)) to WV}
\usage{
ma1_to_wv(theta, sigma2, tau)
}
\arguments{
\item{theta}{A \code{double} corresponding to the moving average term.}

\item{sigma2}{A \code{double} the variance of the process.}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the MA(1) process.
}
\description{
This function computes the WV (haar) of a Moving Average order 1 (MA1) process.
}
\details{
This function is significantly faster than its generalized counter part
\code{\link{arma_to_wv}}.
}
\section{Process Haar Wavelet Variance Formula}{

The Moving Average Order \eqn{1} (MA(\eqn{1})) process has a Haar Wavelet Variance given by:
\deqn{\nu _j^2\left( {\theta ,{\sigma ^2}} \right) = \frac{{\left( {{{\left( {\theta  + 1} \right)}^2}{\tau _j} - 6\theta } \right){\sigma ^2}}}{{\tau _j^2}}}{nu[j]^2 = ((theta+1)^2 * tau[j] - 6*theta)*sigma2 / tau[j]^2}
}

