% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOxygen.R
\name{makeOxygen}
\alias{makeOxygen}
\title{Creates skeleton roxygen2 with information from within function script}
\usage{
makeOxygen(obj, add_default = TRUE, add_fields = c("details", "examples",
  "seealso", "rdname", "export"), use_dictionary = NULL, print = TRUE, ...)
}
\arguments{
\item{obj}{function or name of function}

\item{add_default}{boolean to add defaults values to the end of the PARAM fields, Default: TRUE}

\item{add_fields}{character vector to add additional roxygen2 fields, Default: NULL}

\item{use_dictionary}{character, path_to_dictionary, Default: NULL}

\item{print}{boolean print output to console, Default: TRUE}

\item{...}{arguments to be passed to makeImport}
}
\description{
Creates roxygen2 skeleton including title, description, import and other fields
}
\details{
add_fields can include any slot except for the defaults (title,description,param,return). 
The order in add_fields determines the order of printout. The roxygen2 fields to add are list below, 
for more information go to \href{https://CRAN.R-project.org/package=roxygen2/vignettes/rd.html}{Generating Rd files}
\tabular{ll}{
\strong{Field}    \tab \strong{Skeleton}                           \cr
author            \tab AUTHOR [AUTHOR_2]                           \cr
backref           \tab src/filename.cpp                            \cr
concept           \tab CONCEPT_TERM_1 [CONCEPT_TERM_2]             \cr
describeIn        \tab FUNCTION_NAME DESCRIPTION                   \cr
details           \tab DETAILS                                     \cr
example           \tab path/relative/to/packge/root                \cr
export            \tab                                             \cr
family            \tab FAMILY_TITLE                                \cr
field             \tab FIELD_IN_S4_RefClass DESCRIPTION            \cr
format            \tab DATA_STRUCTURE                              \cr
importClassesFrom \tab PKG CLASS_a [CLASS_b]                       \cr
importMethodsFrom \tab PKG METHOD_a [METHOD_b]                     \cr
include           \tab FILENAME.R [FILENAME_b.R]                   \cr
inherit           \tab [PKG::]SOURCE_FUNCTION [FIELD_a FIELD_b]    \cr
inheritDotParams  \tab [PKG::]SOURCE_FUNCTION                      \cr
inheritSection    \tab [PKG::]SOURCE_FUNCTION [SECTION_a SECTION_b]\cr
keywords          \tab KEYWORD_TERM                                \cr
name              \tab NAME                                        \cr
rdname            \tab FUNCTION_NAME                               \cr
references        \tab BIB_CITATION                                \cr
section           \tab SECTION_NAME                                \cr
source            \tab \\url\{http://somewhere.important.com/\}    \cr
slot              \tab SLOTNAME DESCRIPTION                        \cr
template          \tab FILENAME                                    \cr
templateVar       \tab NAME VALUE                                  \cr
useDynLib         \tab PKG [routine_a routine_b]               
}
}
\examples{
makeOxygen(stats::lm,add_default = TRUE,add_fields = c('export','examples'))
}
