% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOxyFile.R
\name{makeOxyFile}
\alias{makeOxyFile}
\title{Inserts roxygen2 skeletons in file(s).}
\usage{
makeOxyFile(input = NULL, overwrite = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{input}{character, vector of path(s) to one or more .R files, a path to directory containing .R files, Default: NULL}

\item{overwrite}{boolean, If TRUE overwrites file(s), FALSE writes "Oxy"- prefixed files in the same directory, Default: FALSE}

\item{verbose}{boolean, If TRUE will print output to console and open edited files in the editor viewer, Defulat: TRUE}

\item{...}{additional parameters passed to \code{makeOxygen}}
}
\value{
Nothing. Writes files with roxygen2 comments as a side effect
}
\description{
Applies \code{makeOxygen} function to all functions/dataframes in supplied file(s)
}
\details{
If an object cannot be found it will be sourced into a temporary environment.
If the file already contains roxygen2 comments they will be deleted to avoid duplication.
Some functions may require attaching additional packages. For instance, if functions
were defined with purrr's \code{compose} or \code{partial} functions, omission of \code{purr::} in definitions will
require \code{library(purrr)} before proceding with \code{makeOxyFile}.
}
\examples{
\dontrun{
if(interactive()){
 makeOxyFile() # default args, opens system file selection dialogue
 }
 makeOxyFile("./myRfunctions/utils.R") # on one R file
 makeOxyFile("./myRfunctions/") # on all R files in directory
 
 # adds more fields to defaults, passes "cut" to makeImport
 
 sinew_opts$append(list(add_fields=c("concept", "describeIn")))
 makeOxyFile("./myRfunctions/utils.R", cut = 5)
 }
}
\seealso{
\code{\link{makeOxygen}}
}
\author{
Anton Grishin
}
