% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_clustering_highD.R
\name{hclust_haystack_highD}
\alias{hclust_haystack_highD}
\title{Function for hierarchical clustering of genes according to their distribution in a higher-dimensional space.}
\usage{
hclust_haystack_highD(
  x,
  detection,
  genes,
  method = "ward.D",
  grid.coordinates = NULL,
  scale = TRUE
)
}
\arguments{
\item{x}{Coordinates of cells in a 2D or higher-dimensional space. Rows represent cells, columns the dimensions of the space.}

\item{detection}{A logical matrix showing which genes (rows) are detected in which cells (columns)}

\item{genes}{A set of genes (of the 'detection' data) which will be clustered.}

\item{method}{The method to use for hierarchical clustering. See '?hclust' for more information. Default: "ward.D".}

\item{grid.coordinates}{Coordinates of grid points in the same space as 'x', to be used to estimate densities for clustering.}

\item{scale}{whether to scale data.}
}
\value{
An object of class hclust, describing a hierarchical clustering tree.
}
\description{
Function for hierarchical clustering of genes according to their distribution in a higher-dimensional space.
}
\examples{
# to be added
}
