 
#******************************************************************************************************
# Yen's Q3 statistic (1984)
##NS export(yen.q3)
yen.q3 <- function( dat , theta , b , progress = TRUE ){
        # INPUT:
        # dat       ... data frame
        # theta     ... theta estimate
        # b         ... item difficulty estimate
        cat("Yen's Q3 Statistic based on an estimated theta score \n*** " )
        I <- ncol(dat)
        cat(I , "Items | " )
        # expected probability
        expected <- .prob.rasch( theta , b )
        # residual 
        residual <- dat - expected  
        # initialize matrix of Q3 values
        I <- ncol(dat)
        q3.matr <- matrix( NA , I , I )
        q3.long <- matrix( NA , (I-1)*I/2 , 4 )
        colnames(q3.matr) <- rownames(q3.matr) <- colnames(dat)
		q3.matr <- stats::cor( residual , use = "pairwise.complete.obs")		
		nares <- 1 - is.na(residual)
#		NIP <- t(nares) %*% nares
		NIP <- crossprod(nares)
		itempairs <- t( combn( I , 2 ) )
		q3.long[,3] <- q3.matr[ itempairs ]
		q3.long[,4] <- NIP[ itempairs ]
		q3.long[,1] <- colnames(q3.matr)[ itempairs[,1] ]
		q3.long[,2] <- colnames(q3.matr)[ itempairs[,2] ]			
        q3.long <- as.data.frame( q3.long )
        q3.long[,3] <- as.numeric( paste( q3.long[,3] ))
        q3.long <- q3.long[ order( q3.long[,3] ) , ]
        colnames(q3.long) <- c("Item1" , "Item2" , "Q3" , "N" )
        q3.long <-   q3.long[ !is.na( q3.long[,3] ) , ]
		cat( paste( nrow(q3.long) , "item pairs\n" ) )
		MQ3 <- mean( q3.long[,3] )
		SDQ3 <- stats::sd( q3.long[,3] )
		Q3.stat <- stats::quantile( q3.long[,3] , prob = c(  .10 , .25 , .50 , .75 , .90  ) )
		Q3.stat <- c("M" = MQ3 , "SD" = SDQ3 , "Min" = min(q3.long[,3] ) , 
					Q3.stat , "Max" = max(q3.long[,3] ) )
		cat("*** Q3 Descriptives\n")
		print(round(Q3.stat,3))
        res <- list( "q3.matrix" = q3.matr , "q3.long" = q3.long ,
		"expected" = expected , "residual" = residual , "Q3.stat" = Q3.stat )
        return(res)
        }
#*****************************************************************************************************************

Q3 <- yen.q3

############################################################################################################
# Summarizing testlet effect using Q3 statistic     
##NS export(testlet.yen.q3)                                                        
testlet.yen.q3 <- function( q3.res , testlet.matrix ){
        # INPUT:
        # q3.res    ... object generated by yen.q3
        # testlet.matrix    ... matrix -> column 1: testlet label, column 2: item label
        N.item.testlet <- stats::aggregate( rep(1, nrow(testlet.matrix) ) , list( testlet.matrix[,1]) , sum )
        testlet.matrix <- testlet.matrix[ testlet.matrix[,1] %in% N.item.testlet[ N.item.testlet[,2] > 1 , 1 ] , ]
        testlets <- sort( unique( testlet.matrix[,1] ) )
        testlet.q3 <- t( sapply( testlets , FUN = function(testlet){
            testlet.items <- testlet.matrix[ testlet.matrix[,1] == testlet , 2 ]
            ti.ind <- colnames(q3.res$q3.matrix) %in% testlet.items			
            # c( sum( ti.ind) , mean( q3.res$q3.matrix[ ti.ind , ti.ind ] , na.rm=T ) )
			# correction thanks to Thomas Kiefer (2014-03-06)
			c( sum( ti.ind) , mean( q3.res$q3.matrix[ ti.ind , ti.ind ][ lower.tri(diag(sum(ti.ind))) ] ,
					na.rm=TRUE ) )			
                } ) )
        colnames(testlet.q3) <- c("N.Items" , "Mean.Q3" )
        testlet.q3 <- data.frame( "Testlet" = testlets , testlet.q3 , "mean" = mean(q3.res$q3.long[,3]) )
        rownames(testlet.q3) <- NULL
        # mean Q3-statistics between testlets
        TT <- length(testlets)
        matr <- matrix( 1 , nrow= TT , ncol=TT )
        colnames(matr) <- rownames(matr) <- testlets
        for (ii1 in seq(1,TT-1)){
            for (ii2 in seq(ii1+1 , TT )){
            tt1 <- paste(testlets[ii1])
            tt2 <- paste(testlets[ii2])
            itt1 <- testlet.matrix[ testlet.matrix[ ,1] == tt1 ,2 ]
            itt2 <- testlet.matrix[ testlet.matrix[ ,1] == tt2 ,2 ]    
            q.tt <- q3.res$q3.matrix[ paste( itt1 ) , paste( itt2) ] 
            matr[ tt1 , tt2 ] <- matr[tt2,tt1] <- mean( q.tt , na.rm=T )
                                 } 
                            }
		diag(matr) <- testlet.q3$Mean.Q3
        cat( "\nMean Q3 Testlets:" , round( mean(testlet.q3$Mean.Q3) , 5 ),"\n\n")
        print( testlet.q3 , digits = 3 )
        cat( "\n\nMean Q3 between testlets \n\n")
		matr1 <- round( matr , 3 )
        print( matr1 , digits = 3 )

        res <- list( "testlet.q3" = testlet.q3 , "testlet.q3.korr" = matr )
        return(res)
    }
#############################################################################################################

Q3.testlet <- testlet.yen.q3
