% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sirus.R
\name{sirus.plot.cv}
\alias{sirus.plot.cv}
\title{Plot SIRUS cross-validation path.}
\usage{
sirus.plot.cv(sirus.cv.grid, p0.criterion = NULL, num.rule.max = 25)
}
\arguments{
\item{sirus.cv.grid}{Cross-validation results returned by \code{\link{sirus.cv}}.}

\item{p0.criterion}{Criterion to pick the optimal \code{p0} displayed in the plots: if 'pred' then \code{p0.pred} is used for a minimal error, if 'stab' then \code{p0.stab} is used for a tradeoff error/stability. Default is 'pred' for classification and 'stab' for regression.}

\item{num.rule.max}{Upper limit on the number of rules for the x-axis. Default is 25.}
}
\value{
Plots of cross-validation results.
  \item{\code{error}}{plot of error vs number of rules (ggplot2 object).}
  \item{\code{stability}}{plot of stability vs number of rules (ggplot2 object).}
}
\description{
Plot SIRUS cross-validation path: error and stability versus the number of rules when \code{p0} varies.
}
\details{
Error is 1-AUC for classification and the unexplained variance for regression.
Stability is the average proportion of rules shared by two SIRUS models fit on two distinct folds of the cross-validation.
}
\examples{
## load SIRUS
require(sirus)

## prepare data
data <- iris
y <- rep(0, nrow(data))
y[data$Species == 'setosa'] = 1
data$Species <- NULL

## run cv
cv.grid <- sirus.cv(data, y, nfold = 3, ncv = 2, num.trees = 100)

## plot cv result
plot.error <- sirus.plot.cv(cv.grid)$error
plot(plot.error)

}
