% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{createStochSystem}
\alias{createStochSystem}
\title{Creates a stochastic system from an in silico system.}
\usage{
createStochSystem(
  insilicosystem,
  writefile = F,
  filepath = NULL,
  filename = "simulation",
  verbose = T,
  ev = getJuliaEvaluator()
)
}
\arguments{
\item{insilicosystem}{The in silico system (object of class \code{insilicosystem}, see \code{\link{createInSilicoSystem}}).}

\item{writefile}{Does the julia function write the species and reactions lists in a text file?}

\item{filepath}{If writefile = \code{TRUE}, path to the folder in which the files will be created (default: current working directory).}

\item{filename}{If writefile = \code{TRUE}, prefix of the files created to store the lists of species and reactions (default: none).}

\item{verbose}{If TRUE (default), print messages to signal the start and finish of the function.}

\item{ev}{A Julia evaluator (for the XRJulia). If none provided select the current evaluator or create one if no evaluator exists.}
}
\value{
A Julia proxy object to retrieve the stochastic system in the Julia evaluator.
}
\description{
Creates a list of molecules, reactions and associated propensities to represent the in silico system.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5)
stochsys = createStochSystem(mysystem)
}
}
