% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BICadj.R
\name{BICadj}
\alias{AICadj}
\alias{BICadj}
\alias{varexp}
\title{Ways to compare SITAR models for fit}
\usage{
BICadj(..., pattern = NULL)

AICadj(..., k = 2, pattern = NULL)

varexp(..., pattern = NULL)
}
\arguments{
\item{pattern}{regular expression defining names of SITAR models.}

\item{k}{numeric, the penalty per parameter to be used; the default k = 2 is
the classical AIC.}

\item{\dots}{one or more SITAR models.}
}
\value{
For \code{BICadj} and \code{AICadj} a named vector of deviances in
increasing order.  For \code{varexp} a named vector of percentages in
decreasing order.
}
\description{
\code{BICadj} and \code{AICadj} calculate the BIC and AIC for SITAR models,
adjusting the likelihood for Box-Cox transformed y variables. \code{varexp}
calculates the variance explained by SITAR models, compared to the
corresponding fixed effect models.
}
\details{
The deviance is adjusted if the y variable is power-transformed, using the
formula
\deqn{adjusted deviance = deviance - 2n ( (\lambda-1) * log(gm) + %
log(abs(\lambda)) )}{%
deviance - 2n ( (lambda-1) * log(gm) + log(abs(lambda)) )}
where \eqn{\lambda}{lambda} is the power transform, and \eqn{n} and
\eqn{gm} are the length and geometric mean of \code{y}.

The variance explained is given by \deqn{\% explained = 100 * (1 -%
(\sigma_2/\sigma_1)^2)}{\% explained = 100 * (1 - (sigma2/sigma1)^2)} where
\eqn{\sigma_1}{sigma1} is the fixed effects RSD and \eqn{\sigma_2}{sigma2}
the SITAR random effects RSD.

\code{BICadj} and \code{AICadj} accept non-\code{sitar} models with a
\code{logLik} class. \code{varexp} ignores objects not of class
\code{sitar}.
}
\examples{
data(heights)
## fit sitar model for height
m1 <- sitar(x=age, y=height, id=id, data=heights, df=5)

## update it for log(height)
m2 <- update(m1, y=sqrt(height))

## compare variance explained in the two models
varexp(m1, m2)

## compare BIC adjusting for sqrt transform
## the pattern matches names starting with "m" followed by a digit
BICadj(pattern="^m[0-9]")

}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
\seealso{
\code{\link{BIC}}, \code{\link{AIC}}
}
\keyword{regression}

