% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_machine_learning.R
\name{sits_formula_linear}
\alias{sits_formula_linear}
\title{Define a linear formula for classification models}
\usage{
sits_formula_linear(predictors_index = -2:0)
}
\arguments{
\item{predictors_index}{Index of the valid columns
whose names are used to compose formula (default: -2:0).}
}
\value{
A function that computes a valid formula using a linear function.
}
\description{
Provides a symbolic description of a fitting model.
Tells the model to do a linear transformation of the input values.
The `predictors_index` parameter informs the positions of fields
corresponding to formula independent variables.
If no value is given,  that all fields will be used as predictors.
}
\examples{
if (sits_run_examples()) {
    # Example of training a model for time series classification
    # Retrieve the samples for Mato Grosso
    # train an SVM model
    ml_model <- sits_train(samples_modis_ndvi,
        ml_method = sits_svm(formula = sits_formula_logref()))
    # classify the point
    point_ndvi <- sits_select(point_mt_6bands, bands = "NDVI")
    # classify the point
    point_class <- sits_classify(
        data = point_ndvi, ml_model = ml_model
    )
    plot(point_class)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Alexandre Ywata de Carvalho, \email{alexandre.ywata@ipea.gov.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}
}
