% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.variance_cube}
\alias{plot.variance_cube}
\title{Plot variance cubes}
\usage{
\method{plot}{variance_cube}(
  x,
  ...,
  tile = x[["tile"]][[1]],
  labels = NULL,
  palette = "YlGnBu",
  style = "cont",
  n_colors = 10,
  rev = FALSE,
  type = "map",
  scale = 0.8
)
}
\arguments{
\item{x}{Object of class "variance_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{tile}{Tile to be plotted.}

\item{labels}{Labels to plot (optional).}

\item{palette}{RColorBrewer palette}

\item{style}{Method to process the color scale
("cont", "order", "quantile", "fisher",
 "jenks", "log10")}

\item{n_colors}{Number of colors to be shown}

\item{rev}{Reverse order of colors in palette?}

\item{type}{Type of plot ("map" or "hist")}

\item{scale}{Scale to plot map (0.4 to 1.0)}
}
\value{
A plot containing probabilities associated
                      to each class for each pixel.
}
\description{
plots a probability cube using stars
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # obtain a variance cube
    var_cube <- sits_variance(probs_cube, output_dir = tempdir())
    # plot the variance cube
    plot(var_cube)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
