% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.vector_cube}
\alias{plot.vector_cube}
\title{Plot RGB vector data cubes}
\usage{
\method{plot}{vector_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tile = x[["tile"]][[1L]],
  dates = NULL,
  seg_color = "yellow",
  line_width = 0.3,
  palette = "RdYlGn",
  rev = FALSE,
  scale = 1,
  first_quantile = 0.02,
  last_quantile = 0.98,
  max_cog_size = 1024L,
  legend_position = "inside"
)
}
\arguments{
\item{x}{Object of class "raster_cube".}

\item{...}{Further specifications for \link{plot}.}

\item{band}{Band for plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tile}{Tile to be plotted.}

\item{dates}{Dates to be plotted.}

\item{seg_color}{Color to show the segment boundaries}

\item{line_width}{Line width to plot the segments boundary (in pixels)}

\item{palette}{An RColorBrewer palette}

\item{rev}{Reverse the color order in the palette?}

\item{scale}{Scale to plot map (0.4 to 1.5)}

\item{first_quantile}{First quantile for stretching images}

\item{last_quantile}{Last quantile for stretching images}

\item{max_cog_size}{Maximum size of COG overviews (lines or columns)}

\item{legend_position}{Where to place the legend (default = "inside")}
}
\value{
A plot object with an RGB image
                      or a B/W image on a color
                      scale using the palette
}
\description{
Plot vector data cube with segments on top of raster image.
Vector cubes have both a vector and a raster component. The vector part
are the segments produced by \code{\link{sits_segment}}. Their
visual output is controlled by "seg_color" and "line_width" parameters.
The raster output works in the same way as the false color and RGB plots.
}
\note{
The following optional parameters are available to allow for detailed
      control over the plot output:
\itemize{
\item \code{graticules_labels_size}: size of coord labels (default = 0.7)
\item \code{legend_title_size}: relative size of legend title (default = 0.7)
\item \code{legend_text_size}: relative size of legend text (default = 0.7)
\item \code{legend_bg_color}: color of legend background (default = "white")
\item \code{legend_bg_alpha}: legend opacity (default = 0.3)
}
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # Segment the cube
    segments <- sits_segment(
        cube = cube,
        output_dir = tempdir(),
        multicores = 2,
        memsize = 4
    )
    # plot NDVI band of the second date date of the data cube
    plot(segments, band = "NDVI", date = sits_timeline(cube)[1])
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
