% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics_metrics.R
\name{basics_metrics}
\alias{basics_metrics}
\alias{max_ts}
\alias{min_ts}
\alias{mean_ts}
\alias{median_ts}
\alias{sum_ts}
\alias{std_ts}
\alias{skew_ts}
\alias{kurt_ts}
\alias{amplitude_ts}
\alias{fslope_ts}
\alias{abs_sum_ts}
\alias{amd_ts}
\alias{mse_ts}
\alias{fqr_ts}
\alias{sqr_ts}
\alias{tqr_ts}
\alias{iqr_ts}
\title{Basics metrics}
\usage{
max_ts(timeseries)

min_ts(timeseries)

mean_ts(timeseries)

median_ts(timeseries)

sum_ts(timeseries)

std_ts(timeseries)

skew_ts(timeseries)

kurt_ts(timeseries)

amplitude_ts(timeseries)

fslope_ts(timeseries)

abs_sum_ts(timeseries)

amd_ts(timeseries)

mse_ts(timeseries)

fqr_ts(timeseries)

sqr_ts(timeseries)

tqr_ts(timeseries)

iqr_ts(timeseries)
}
\arguments{
\item{timeseries}{a \code{numeric} or \code{matrix} object where the
columns is the point in time.}
}
\value{
a \code{numeric} vector for each metric in each time series
}
\description{
The package sitsfeats provides a set of basics metrics:
\itemize{
  \item The \code{max_ts()} retrieves the maximum value contained in the time
   series.
  \item The \code{min_ts()} retrieves the minimum value contained in the time
   series.
  \item The \code{mean_ts()} retrieves the mean value of the time series.
  \item The \code{median_ts()} retrieves the median value of the time series.
  \item The \code{sum_ts()} retrieves the sum of all time series points.
  \item The \code{std_ts()} retrieves the standard deviation of the time
  series.
  \item The \code{skew_ts()} retrieves the skewness of the time series.
  \item The \code{kurt_ts()} retrieves the kurtosis of the time series.
  \item The \code{amplitude_ts()} retrieves the amplitude of the time series.
  \item The \code{fslope_ts()} retrieves the first slope of the time series.
  \item The \code{abs_sum_ts()} retrieves the absolute sum of the time series
   points.
  \item The \code{amd_ts()} retrieves the absolute mean of the difference
  between each point in the time series.
  \item The \code{mse_ts()} retrieves the mean spectral energy of the time
  series.
  \item The \code{fqr_ts()} retrieves the value of the first quartile of the
  time series (0.25).
  \item The \code{sqr_ts()} retrieves the value of the second quartile of the
   time series (0.50).
  \item The \code{tqr_ts()} retrieves the value of the third quartile of the
   time series (0.75).
  \item The \code{iqr_ts()} retrieves the interquartile range
  (difference between the third and first quartile).
 }
}
\examples{
data("timeseries")
mean_values <- sitsfeats::mean_ts(timeseries)

}
