% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{sju.dicho}
\alias{sju.dicho}
\title{Dichotomize variables}
\usage{
sju.dicho(var, dichBy = "median", dichVal = -1, asNum = FALSE)
}
\arguments{
\item{var}{The variable that should be dichotomized.}

\item{dichBy}{Indicates the split criterion where the variable is dichotomized. By default,
\code{var} is split into two groups at the median (\code{dichBy="median"} or
\code{dichBy="md"}). Further values for \code{dichBy} are \code{"mean"} (or \code{"m"}),
which splits into groups at the mean of \code{var}; and \code{"value"} (or \code{"v"}).
In the latter case, you have to specifiy \code{dichVal}.}

\item{dichVal}{Indicates a value where \code{var} is dichotomized when \code{dichBy="value"}.
Note that \code{dichVal} is inclusive, i.e. \code{dichVal=10} will split \code{var}
into one group with values from lowest to 10 and another group with values greater
than 10.}

\item{asNum}{If \code{TRUE}, return value will be numeric, not a factor.}
}
\value{
A dichotomized factor (or numeric, if \code{asNum = TRUE} variable (0/1-coded).
}
\description{
Dichotomizes variables into dummy variables (0/1). Dichotomization is
               either done by median or mean (see \code{dichBy}).
}
\examples{
data(efc)
summary(efc$c12hour)
table(sju.dicho(efc$c12hour))
table(sju.dicho(efc$c12hour, "mean"))
table(sju.dicho(efc$c12hour, "value", 30))
}

