% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{sji.getValueLabels}
\alias{sji.getValueLabels}
\title{Retrieve value labels of a variable or an SPSS-imported data frame}
\usage{
sji.getValueLabels(x)
}
\arguments{
\item{x}{a data frame with variables that have attached value labels (e.g.
from an imported SPSS data (see \code{\link{sji.SPSS}})) or a variable
with attached value labels.}
}
\value{
Either a list with all value labels from the data frame's variables,
          or a string with the value labels, if \code{x} is a variable.
}
\description{
This function retrieves the value labels of an imported
               SPSS data set and returns the result as list or of a variable and returns
               the label as string.
}
\examples{
# import SPSS data set
# mydat <- sji.SPSS("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- sji.getVariableLabels(mydat)

# retrieve value labels
# mydat.val <- sji.getValueLabels(mydat)

data(efc)
sji.getValueLabels(efc$e42dep)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/sji.viewSPSS/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{sji.SPSS}}
           \item \code{\link{sji.getVariableLabels}}
           \item \code{\link{sji.convertToLabel}}
           \item \code{\link{sji.convertToValue}}
           \item \code{\link{sji.setValueLabels}}
           }
}

