% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjTabStackFrq.R
\name{sjt.stackfrq}
\alias{sjt.stackfrq}
\title{Show stacked frequencies as HTML table}
\usage{
sjt.stackfrq(items, weightBy = NULL, title = NULL, varlabels = NULL,
  breakLabelsAt = 40, valuelabels = NULL, breakValueLabelsAt = 20,
  sort.frq = NULL, alternateRowColors = FALSE, digits = 2,
  showN = FALSE, showTotalN = FALSE, showNA = FALSE, labelNA = "NA",
  showSkew = FALSE, showKurtosis = FALSE, digits.stats = 2,
  skewString = "Skew", kurtosisString = "Kurtosis", file = NULL,
  encoding = NULL, CSS = NULL, useViewer = TRUE, no.output = FALSE,
  remove.spaces = TRUE)
}
\arguments{
\item{items}{A \code{\link{data.frame}} with each column representing one (likert- or scale-)item.}

\item{weightBy}{A weight factor that will be applied to weight all cases from \code{items}.
Must be a vector of same length as \code{nrow(items)}. Default is \code{NULL}, so no weights are used.}

\item{title}{A table caption.}

\item{varlabels}{A list or vector of strings with variable names. If not specified, row names of \code{items}
will be used, resp. variable labels will automatically be detected, when they have
a variable label attribute (see \code{\link[sjmisc]{set_var_labels}}) for details).}

\item{breakLabelsAt}{Wordwrap for variable labels. Determines how many chars of the variable labels are displayed in
one line and when a line break is inserted. Default is 40.}

\item{valuelabels}{A list or vector of strings that category/value labels, which
appear in the header row.}

\item{breakValueLabelsAt}{Wordwrap for value labels. Determines how many chars of the value labels are displayed in
one line and when a line break is inserted. Default is 20.}

\item{sort.frq}{Indicates whether the \code{items} should be ordered by
by highest count of first or last category of \code{items}.
\itemize{
  \item Use \code{"first.asc"} to order ascending by lowest count of first category,
  \item \code{"first.desc"} to order descending by lowest count of first category,
  \item \code{"last.asc"} to order ascending by lowest count of last category,
  \item \code{"last.desc"} to order descending by lowest count of last category,
  \item or \code{NULL} (default) for no sorting.
}}

\item{alternateRowColors}{If \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{digits}{The amount of digits for rounding the percentage values.
Default is 2, i.e. percentage values have 2 digits after decimal point.}

\item{showN}{If \code{TRUE}, each item's category N is printed in the table cells.}

\item{showTotalN}{If \code{TRUE}, an additional column with each item's total N is printed.}

\item{showNA}{If \code{TRUE}, \code{\link{NA}}'s (missing values) are also printed in the table.}

\item{labelNA}{The label for the missing column/row.}

\item{showSkew}{If \code{TRUE}, an additional column with each item's skewness is printed.
The skewness is retrieved from the \code{\link[psych]{describe}} function of the \code{psych}
package.}

\item{showKurtosis}{If \code{TRUE}, an additional column with each item's kurtosis is printed.
The kurtosis is retrieved from the \code{\link[psych]{describe}} function of the \code{psych}
package.}

\item{digits.stats}{The amount of digits for rounding the skewness and kurtosis valuess.
Default is 2, i.e. skewness and kurtosis values have 2 digits after decimal point.}

\item{skewString}{A character string, which is used as header for the skew column (see \code{showSkew})).
Default is \code{"Skew"}.}

\item{kurtosisString}{A character string, which is used as header for the kurtosis column (see \code{showKurtosis})).
Default is \code{"Kurtosis"}.}

\item{file}{The destination file, which will be in html-format. If no filepath is specified,
the file will be saved as temporary file and openend either in the RStudio View pane or
in the default web browser.}

\item{encoding}{The charset encoding used for variable and value labels. Default is \code{NULL}, so encoding
will be auto-detected depending on your platform (\code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g.) German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{If \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows the results of stacked frequencies (such as likert scales) as HTML table.
               This function is useful when several items with identical scale/categories
               should be printed as table to compare their distributions (e.g.
               when plotting scales like SF, Barthel-Index, Quality-of-Life-scales etc.).
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
# -------------------------------
# random sample
# -------------------------------
# prepare data for 4-category likert scale, 5 items
likert_4 <- data.frame(as.factor(sample(1:4,
                                        500,
                                        replace = TRUE,
                                        prob = c(0.2, 0.3, 0.1, 0.4))),
                       as.factor(sample(1:4,
                                        500,
                                        replace = TRUE,
                                        prob = c(0.5, 0.25, 0.15, 0.1))),
                       as.factor(sample(1:4,
                                        500,
                                        replace = TRUE,
                                        prob = c(0.25, 0.1, 0.4, 0.25))),
                       as.factor(sample(1:4,
                                        500,
                                        replace = TRUE,
                                        prob = c(0.1, 0.4, 0.4, 0.1))),
                       as.factor(sample(1:4,
                                        500,
                                        replace = TRUE,
                                        prob = c(0.35, 0.25, 0.15, 0.25))))
# create labels
levels_4 <- c("Independent",
              "Slightly dependent",
              "Dependent",
              "Severely dependent")

# create item labels
items <- c("Q1", "Q2", "Q3", "Q4", "Q5")

# plot stacked frequencies of 5 (ordered) item-scales
\dontrun{
sjt.stackfrq(likert_4, valuelabels = levels_4, varlabels = items)


# -------------------------------
# Data from the EUROFAMCARE sample dataset
# Auto-detection of labels
# -------------------------------
library(sjmisc)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive first item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

sjt.stackfrq(efc[, c(start:end)],
             alternateRowColors = TRUE)

sjt.stackfrq(efc[, c(start:end)],
             alternateRowColors = TRUE,
             showN = TRUE,
             showNA = TRUE)


# --------------------------------
# User defined style sheet
# --------------------------------
sjt.stackfrq(efc[, c(start:end)],
             alternateRowColors = TRUE,
             showTotalN = TRUE,
             showSkew = TRUE,
             showKurtosis = TRUE,
             CSS = list(css.ncol = "border-left:1px dotted black;",
                        css.summary = "font-style:italic;"))}
}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjt.stackfrq}{sjPlot manual: sjt-basics}
             \item \code{\link{sjp.stackfrq}}
             \item \code{\link{sjp.likert}}
             }
}

