% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjTabMannWhitney.R
\name{sjt.mwu}
\alias{sjt.mwu}
\title{Summary of Mann-Whitney-Test as HTML table}
\usage{
sjt.mwu(x, title = NULL, alternateRowColors = TRUE, file = NULL,
  encoding = NULL, CSS = NULL, useViewer = TRUE, no.output = FALSE,
  remove.spaces = TRUE)
}
\arguments{
\item{x}{Results of a Mann-Whitney-U test, provided by \code{\link[sjmisc]{mwu}}. See examples.}

\item{title}{table caption. By default, \code{title = NULL}, hence no title will be used.}

\item{alternateRowColors}{logical, if \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{file}{destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{encoding}{string, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{\code{\link{list}}-object with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See 'Details'.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns a \code{\link{list}} with
         \itemize{
           \item the data frame with the description information (\code{data}),
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows the results of a Mann-Whitney-U-test as HTML table. The results
               from the Mann-Whitney-test are obtained by the \code{\link[sjmisc]{mwu}}
               function from the \code{sjmisc} package.
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
\dontrun{
library(sjmisc)
data(efc)
sjt.mwu(mwu(efc$e17age, efc$e42dep))}
}

