% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotGLME.R
\name{sjp.glmer}
\alias{sjp.glmer}
\title{Plot odds ratios or predicted probabilities of generalized linear mixed effects models}
\usage{
sjp.glmer(fit, type = "re", vars = NULL, ri.nr = NULL, emph.grp = NULL,
  title = NULL, geom.size = NULL, geom.colors = "Set1",
  hideErrorBars = FALSE, showIntercept = TRUE,
  stringIntercept = "(Intercept)", sort.coef = NULL, pred.labels = NULL,
  axisTitle.x = NULL, axisTitle.y = NULL, facet.grid = TRUE,
  free.scale = FALSE, interceptLineType = 2,
  interceptLineColor = "grey70", remove.estimates = NULL,
  showValueLabels = TRUE, labelDigits = 2, showPValueLabels = TRUE,
  fade.ns = FALSE, show.ci = FALSE, sample.n = NULL,
  show.legend = FALSE, printPlot = TRUE, show.se = FALSE)
}
\arguments{
\item{fit}{a fitted model as returned by the \code{\link[lme4]{glmer}}-function.}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"re"}}{(default) for odds ratios of random effects}
  \item{\code{"fe"}}{for odds ratios of fixed effects}
  \item{\code{"fe.cor"}}{for correlation matrix of fixed effects}
  \item{\code{"re.qq"}}{for a QQ-plot of random effects (random effects quantiles against standard normal quantiles)}
  \item{\code{"fe.pc"}}{or \code{"fe.prob"} to plot probability curves (predicted probabilities) of all fixed effects coefficients. Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot. See 'Details'.}
  \item{\code{"ri.pc"}}{or \code{"ri.prob"} to plot probability curves (predicted probabilities) of random intercept variances for all fixed effects coefficients. Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot. See 'Details'.}
  \item{\code{"rs.ri"}}{for fitted probability curves (predicted probabilities) indicating the random slope-intercept pairs. Use this to visualize the random parts of random slope-intercept (or repeated measure) models. When having too many groups, use \code{sample.n} argument.}
  \item{\code{"eff"}}{to plot marginal effects of predicted probabilities for each fixed term, where remaining co-variates are set to the mean. Use \code{facet.grid} to decide whether to plot each coefficient as separate plot or as integrated faceted plot. See 'Details'.}
  \item{\code{"y.pc"}}{or \code{"y.prob"} to plot predicted probabilities for the response, with and without random effects. Use \code{facet.grid} to decide whether to plot with and w/o random effect plots as separate plot or as integrated faceted plot. See 'Details'.}
}}

\item{vars}{numeric vector with column indices of selected variables or a character vector with
variable names of selected variables from the fitted model, which should be used to plot
estimates, fixed effects slopes (for \code{\link[lme4]{lmer}}) or probability curves
(for \code{\link[lme4]{glmer}}) of random intercepts. This argument
applies if \code{type} is \code{"fe"}, \code{"fe.std"}, \code{"re"},
\code{"fe.pc"}, \code{"ri.pc"} or \code{"fe.ri"}.
In this case, only those terms specified in \code{"vars"} will be plotted.}

\item{ri.nr}{numeric vector. If \code{type = "re"}, \code{type = "ri.pc"} or \code{type = "fe.ri"},
and fitted model has more than one random intercept, \code{ri.nr} indicates
which random effects of which random intercept (or: which list elements
of \code{\link[lme4]{ranef}}) will be plotted. Default is \code{NULL},
so all random effects will be plotted.}

\item{emph.grp}{numeric vector with index numbers of grouping levels (from random effect).
If \code{type = "ri.pc"} or \code{type = "fe.ri"}, and \code{facet.grid = FALSE},
an integrated plot of predicted probabilities of fixed effects resp. fixed
effects slopes for each grouping level is plotted. To better find
certain groups, use this argument to emphasize these groups in the plot.
See 'Examples'.}

\item{title}{character vector with one or more labels that are used as plot title. If
\code{type = "re"}, use the predictors' variable labels as titles.}

\item{geom.size}{size of geoms (point size or line size, depending on \code{type}-argument).}

\item{geom.colors}{user defined color palette for geoms. Must either be vector with two color values
or a specific color palette code. See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{hideErrorBars}{logical, if \code{TRUE}, the error bars that indicate the confidence intervals of the odds ratios are not
shown.}

\item{showIntercept}{logical, if \code{TRUE}, the intercept is included when plotting random or fixed effects.}

\item{stringIntercept}{string, label of intercept estimate on the y axis. Only applies, if \code{showIntercept}
is \code{TRUE} and \code{pred.labels} is not \code{NULL}.}

\item{sort.coef}{indicates which coefficient should be used for sorting odds ratios
\itemize{
  \item If \code{NULL} (default), no sorting is done and odds ratios are sorted in order of model coefficients.
  \item If \code{sort.coef = "sort.all"}, odds ratios are re-sorted for each coefficient (only applies if \code{type = "re"} and \code{facet.grid = FALSE}), i.e. the odds ratios of the random effects for each predictor are sorted and plotted to an own plot.
  \item If \code{type = "fe"} or \code{type = "fe.std"}, \code{TRUE} will sort estimates
  \item Else, specify a predictor's / coefficient's name to sort odds ratios according to this coefficient.
  }
  See 'Examples'.}

\item{pred.labels}{character vector with labels for the predictors / covariates / groups. Should either be vector
of fixed effects variable labels (if \code{type = "fe"} or \code{type = "fe.std"}) or a vector of group (value)
labels from the random intercept's categories (if \code{type = "re"}).}

\item{axisTitle.x}{title for the x axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{axisTitle.y}{title for the y axis. If not specified, a default labelling depending
on the plot type is chosen.}

\item{facet.grid}{\code{TRUE} when each plot should be plotted separately instead of
an integrated (faceted) single graph.}

\item{free.scale}{if \code{TRUE} and \code{facet.grid = TRUE}, each facet grid
gets its own fitted scale. If \code{free.scale = FALSE}, each facet in
the grid has the same scale range.}

\item{interceptLineType}{linetype of the intercept line (zero point). Default is \code{2} (dashed line).}

\item{interceptLineColor}{color of the intercept line. Default value is \code{"grey70"}.}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{showValueLabels}{logical, whether estimate values should be plotted to each dot or not.}

\item{labelDigits}{numeric, amount of digits for rounding the estimates (see \code{showValueLabels}).
Default is 2, i.e. estimates have 2 digits after decimal point.}

\item{showPValueLabels}{logical, whether the significance levels of each coefficient should be appended
to values or not.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{show.ci}{logical, use \code{TRUE} to plot confidence intervals for 
predicted values or for slope lines.}

\item{sample.n}{only applies, if \code{type = "rs.ri"}. If plot has many random intercepts
(grouping levels), overplotting of regression lines may occur. In this
case, consider random sampling of grouping levels. \code{sample.n} indicates,
how many random cases are sampled for plotting.}

\item{show.legend}{logical, if \code{TRUE}, for mixed models 
\code{type = "rs.ri"}, a legend for group levels of 
the random intercept is shown. For \code{lm} and \code{glm}, 
a legend for grouped estimates is shown.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}

\item{show.se}{Deprecated; use \code{show.ci} instead.}
}
\value{
(Insisibily) returns
         \itemize{
           \item the ggplot-object (\code{plot}), if \code{type = "fe"} or if \code{type = "re"} and \code{facet.grid = TRUE}). Multiple plots (\code{type = "re"} and if \code{facet.grid = FALSE}) are returned in the object \code{plot.list}.
           \item a list of ggplot-objects (\code{plot.list}). See \code{plot} for details.
           \item a data frame \code{mydf} with the data used to build the ggplot-object(s).
           }
}
\description{
By default, this function plots odds ratios (exponentiated coefficients)
               with confidence intervalls of either fixed effects or random effects of
               generalized linear mixed effects models (that have been fitted with the
               \code{\link[lme4]{glmer}}-function of the \pkg{lme4}-package).
               Furthermore, this function also plots predicted probabilities or
               diagnostic plots.
}
\details{
\describe{
           \item{\code{type = "fe.pc"}}{(or \code{"fe.prob"}), the predicted probabilities
           are based on the fixed effects intercept's estimate and each specific
           fixed term's estimate. All other fixed effects are set to zero (i.e. ignored),
           which corresponds to \code{\link{plogis}(b0 + bi * xi)} (where \code{xi}
           is the logit-estimate of fixed effects and \code{b0} is the intercept of
           the fixed effects).}
           \item{\code{type = "eff"}}{unlike \code{type = "fe.pc"}, the predicted
           probabilities computed by \code{type = "eff"} have all co-variates
           set to the mean, as returned by the \code{\link[effects]{allEffects}} function.}
           \item{\code{type = "ri.pc"}}{(or \code{"ri.prob"}), the predicted probabilities
           are based on the fixed effects intercept, plus each random intercept and
           each specific  fixed term's estimate. All other fixed effects are set to zero (i.e. ignored),
           which corresponds to \code{\link{plogis}(b0 + b0[r1-rn] + bi * xi)} (where \code{xi}
           is the logit-estimate of fixed effects, \code{b0} is the intercept of
           the fixed effects and \code{b0[r1-rn]} are all random intercepts).}
           \item{\code{type = "rs.ri"}}{the predicted probabilities are based 
           on the fixed effects intercept, plus each random intercept and
           random slope. This plot type is intended to plot the random part, i.e.
           the predicted probabilities of each random slope for each random intercept.
           Since the random intercept specifies the deviance from the gloabl
           intercept, the global intercept is always included. In case of overplotting,
           use the \code{sample.n} argument to randomly sample a limited amount
           of groups.}
           \item{\code{type = "y.pc"}}{(or \code{type = "y.prob"}), the predicted values
           of the response are computed, based on the \code{predict.merMod}
           method. Corresponds to \code{\link{plogis}(predict(fit, type = "response"))}.}
           \item{\code{type = "coef"}}{forest plot of joint fixed and random
           effect coefficients, as retrieved by \code{\link[lme4]{coef.merMod}},
           it's simply \code{\link[lme4]{ranef} + \link[lme4]{fixef}}.}
           \item{\code{type = "y.pc"}}{(or \code{"y.prob"}) predicted probabilities
           against response, only fixed effects and 
           conditional on random intercept. It's calling
           \code{predict(fit, type = "response", re.form = NA)} resp.
           \code{predict(fit, type = "response", re.form = NULL)} to
           compute the values.}
         }
}
\note{
Thanks go to Robert Reijntjes from Leiden University Medical Center for sharing
        R code that is used to compute fixed effects correlation matrices and
        qq-plots of random effects.
}
\examples{
library(lme4)
library(sjmisc)
# create binary response
sleepstudy$Reaction.dicho <- dicho(sleepstudy$Reaction, dich.by = "md")
# fit model
fit <- glmer(Reaction.dicho ~ Days + (Days | Subject),
             sleepstudy,
             family = binomial("logit"))

# simple plot
sjp.glmer(fit)

# sort by predictor Days
sjp.glmer(fit, sort.coef = "Days")

data(efc)
# create binary response
efc$hi_qol <- dicho(efc$quol_5)
# prepare group variable
efc$grp = as.factor(efc$e15relat)
levels(x = efc$grp) <- get_labels(efc$e15relat)
# data frame for fitted model
mydf <- data.frame(hi_qol = as.factor(efc$hi_qol),
                   sex = as.factor(efc$c161sex),
                   c12hour = as.numeric(efc$c12hour),
                   neg_c_7 = as.numeric(efc$neg_c_7),
                   grp = efc$grp)
# fit glmer
fit <- glmer(hi_qol ~ sex + c12hour + neg_c_7 + (1|grp),
             data = mydf,
             family = binomial("logit"))

# plot and sort fixed effects
sjp.glmer(fit,
          type = "fe",
          sort.coef = TRUE)

# plot probability curves (predicted probabilities)
# for each covariate, grouped by random intercepts
# in integrated plots, emphasizing groups 1 and 4
sjp.glmer(fit,
          type = "ri.pc",
          emph.grp = c(1, 4),
          facet.grid = FALSE)

# plot probability curve (predicted probabilities)
# of fixed effect, only for coefficient "neg_c_7"
sjp.glmer(fit,
          type = "fe.pc",
          vars = "neg_c_7")

}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.glmer/}{sjPlot manual: sjp.glmer}
}

