% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sjSDM.DNN}
\alias{plot.sjSDM.DNN}
\title{Training history}
\usage{
\method{plot}{sjSDM.DNN}(x, ...)
}
\arguments{
\item{x}{a model fitted by \code{\link{sjSDM}} with \code{\link{DNN}} object}

\item{...}{passed to plot}
}
\value{
No return value, called for side effects.
}
\description{
Plot training loss history
}
\examples{
\dontrun{
library(sjSDM)
# simulate community:
com = simulate_SDM(env = 6L, species = 7L, sites = 100L)

# fit model:
model = sjSDM(Y = com$response,env = com$env_weights, iter = 2L,se = TRUE) 

#create a group dataframe for plot
species=c("sp1","sp2","sp3","sp4","sp5","sp6","sp7")
group=c("mammal","bird","fish","fish","mammal","amphibian","amphibian")
group = data.frame(species=species,group=group)

plot(model,group=group)
}
}
