% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{summary.sjSDManova}
\alias{summary.sjSDManova}
\title{Summary table of sjSDM anova}
\usage{
\method{summary}{sjSDManova}(
  object,
  method = c("ANOVA"),
  fractions = c("all", "discard", "proportional", "equal"),
  ...
)
}
\arguments{
\item{object}{an object of \code{\link{anova.sjSDM}}}

\item{method}{method used to calculate the ANOVA}

\item{fractions}{how to handle the shared fractions. See details}

\item{...}{optional arguments for compatibility with the generic function, no function implemented}
}
\value{
The matrix that is printed out is silently returned
}
\description{
The function prints and returns invisible a summary table of an sjSDM ANOVA, created by \code{\link{anova.sjSDM}}
}
\details{
The function returns a ANOVA table with Deviance as well as the pseudo-R2 metrics of Nagelkerke and McFadden

There are four options to handle shared ANOVA fractions, which is variance that can be explained, typically as a result of collinearity, by several of the fractions:
\enumerate{
\item "all" returns the shared fractions explicitly
\item "discard" discards the fractions, as typically in a type II Anova
\item "proportional" distributes shared fractions proportional to the unique fractions
\item "equal" distributions shared fractions equally to the unique fractions
}
}
\examples{
\dontrun{
library(sjSDM)
# simulate community:
community = simulate_SDM(env = 3L, species = 10L, sites = 100L)

Occ <- community$response
Env <- community$env_weights
SP <- data.frame(matrix(rnorm(200, 0, 0.3), 100, 2)) # spatial coordinates


# fit model:
model <- sjSDM(Y = Occ, 
               env = linear(data = Env, formula = ~X1+X2+X3), 
               spatial = linear(data = SP, formula = ~0+X1*X2), 
               family=binomial("probit"),
               verbose = FALSE,
               iter = 20) # increase iter for real analysis

# Calculate ANOVA for env, space, associations, for details see ?anova.sjSDM
an = anova(model, samples = 10, verbose = FALSE) # increase iter for real analysis

# Show anova fractions
plot(an)

# ANOVA tables with different way to handle fractions
summary(an)
summary(an, fractions = "discard")
summary(an, fractions = "proportional")
summary(an, fractions = "equal")

# Internal structure
int = internalStructure(an, fractions = "proportional")

print(int)

plot(int) # default is negative values will be set to 0
plot(int, negatives = "scale") # global rescaling of all values to range 0-1
plot(int, negatives = "raw") # negative values will be discarded

plotAssemblyEffects(int)
plotAssemblyEffects(int, negatives = "floor")
plotAssemblyEffects(int, response = "sites", pred = as.factor(c(rep(1, 50), rep(2, 50))))
plotAssemblyEffects(int, response = "species", pred = runif(10))
plotAssemblyEffects(int, response = "species", pred = as.factor(c(rep(1, 5), rep(2, 5))))
}
}
