% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{read_spss}
\alias{read_spss}
\title{Import SPSS dataset as data frame into R}
\usage{
read_spss(path, enc = NA, autoAttachVarLabels = FALSE,
  atomic.to.fac = FALSE, option = "haven")
}
\arguments{
\item{path}{The file path to the SPSS dataset.}

\item{enc}{The file encoding of the SPSS dataset. \emph{Not needed if \code{option = "haven"} (default).}}

\item{autoAttachVarLabels}{if \code{TRUE}, variable labels will automatically be
attached to each variable as \code{"variable.label"} attribute.
See \code{\link{set_var_labels}} for details.
\emph{Not needed if \code{option = "haven"} (default).}}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
SPSS (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}

\item{option}{string, indicating which package will be used to read the SPSS data file.
By default, \code{option = "haven"}, which means, the \code{read_spss} function
from the \code{haven} package is used. Use \code{option = "foreign"} to
use foreign's \code{read.spss} function. Use \code{options(read_spss = "foreign")}
to make this function always use the foreign-package \code{\link[foreign]{read.spss}} function.}
}
\value{
A data frame containing the SPSS data. Retrieve value labels with \code{\link{get_val_labels}}
  and variable labels with \code{\link{get_var_labels}}.
}
\description{
Import data from SPSS, including NA's, value and variable labels.
}
\note{
This is a wrapper function for \code{\link{read_spss}} of the
        \code{haven} package. This function adds value and variable
        labels to the imported variables of the data frame. \cr \cr
       With attached value and variable labels, most functions of this package
       automatically detect labels and uses them as axis, legend or title labels
       in plots (\code{sjp.}-functions) respectively as column or row headers
       in table outputs (\code{sjt.}-functions). Use \code{options(autoSetValueLabels = FALSE)}
       and \code{options(autoSetVariableLabels = FALSE)} to turn off automatic
       label detection.
}
\examples{
\dontrun{
# import SPSS data set. uses haven's read function
# by default
mydat <- read_spss("my_spss_data.sav")

# use foreign's read function
mydat <- read_spss("my_spss_data.sav",
                   enc = "UTF-8",
                   option = "foreign")

# use haven's read function, convert atomic to factor
mydat <- read_spss("my_spss_data.sav", atomic.to.fac = TRUE)

# retrieve variable labels
mydat.var <- get_var_labels(mydat)

# retrieve value labels
mydat.val <- get_val_labels(mydat)}
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{write_spss}}
           }
}

