% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjRecode.R
\name{word_wrap}
\alias{word_wrap}
\title{Insert line breaks in long labels}
\usage{
word_wrap(labels, wrap, linesep = NULL)
}
\arguments{
\item{labels}{The label(s) (i.e. character string). You can also pass several strings as vector
(e.g. \code{labels=c("first long string", "second long string")})}

\item{wrap}{The amount of chars per line (i.e. line length)}

\item{linesep}{By default, this parameter is \code{NULL} and a regular new line
string is used. For HTML-needs, for instance, \code{linesep} could be \code{"<br>"}.}
}
\value{
New label(s) with line breaks inserted at every \code{wrap}'s position.
}
\description{
Insert line breaks in long character strings. Useful if you want to wordwrap
               plot labels.
}
\examples{
word_wrap(c("A very long string", "And another even longer string!"), 10)
}

