% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std.R
\name{std}
\alias{std}
\alias{center}
\title{Standardize and center variables}
\usage{
std(x, ..., include.fac = TRUE, suffix = "_z")

center(x, ..., include.fac = TRUE, suffix = "_c")
}
\arguments{
\item{x}{A vector or data frame.}

\item{...}{Optional, unquoted names of variables. Required, if \code{x} is
a data frame (and no vector) and only selected variables
from \code{x} should be processed. You may also use functions like
\code{:} or dplyr's \code{\link[dplyr]{select_helpers}}.
The latter must be stated as formula (i.e. beginning with \code{~}).
See 'Examples' or \href{../doc/design_philosophy.html}{package-vignette}.}

\item{include.fac}{Logical, if \code{TRUE}, factors will be converted to numeric
vectors and also standardized or centered.}

\item{suffix}{String value, will be appended to variable (column) names of
\code{x}, if \code{x} is a data frame. If \code{x} is not a data
frame, this argument will be ignored. The default value to suffix
column names in a data frame depends on the function call:
\itemize{
  \item recoded variables (\code{rec()}) will be suffixed with \code{"_r"}
  \item recoded variables (\code{recode_to()}) will be suffixed with \code{"_r0"}
  \item dichotomized variables (\code{dicho()}) will be suffixed with \code{"_d"}
  \item grouped variables (\code{split_var()}) will be suffixed with \code{"_g"}
  \item grouped variables (\code{group_var()}) will be suffixed with \code{"_gr"}
  \item standardized variables (\code{std()}) will be suffixed with \code{"_z"}
  \item centered variables (\code{center()}) will be suffixed with \code{"_c"}
}}
}
\value{
A vector with standardized or centered variables. If \code{x} is a
        data frame, only the transformed variables will be returned.
}
\description{
\code{std()} computes a z-transformation (standardized and centered)
             on the input. \code{center()} centers the input.
}
\note{
\code{std()} and \code{center()} only return a vector, if \code{x} is
        a vector. If \code{x} is a data frame and only one variable is specified
        in the \code{...}-ellipses argument, both functions do return a
        data frame (see 'Examples').
}
\examples{
data(efc)
std(efc$c160age) \%>\% head()
std(efc, e17age, c160age) \%>\% head()

center(efc$c160age) \%>\% head()
center(efc, e17age, c160age) \%>\% head()

# NOTE!
std(efc$e17age) # returns a vector
std(efc, e17age) # returns a tibble

# works with mutate()
library(dplyr)
efc \%>\%
  select(e17age, neg_c_7) \%>\%
  mutate(age_std = std(e17age), burden = center(neg_c_7)) \%>\%
  head()

}
