% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merMod_p.R
\name{p_value}
\alias{p_value}
\title{Get p-values from regression model objects}
\usage{
p_value(fit, p.kr = FALSE)
}
\arguments{
\item{fit}{A fitted model object of class \code{lm}, \code{glm}, \code{merMod},
\code{merModLmerTest}, \code{pggls} or \code{gls}. Other classes may
work as well.}

\item{p.kr}{Logical, if \code{TRUE}, the computation of p-values is based on
conditional F-tests with Kenward-Roger approximation for the df (see
'Details').}
}
\value{
A \code{data.frame} with the model coefficients' names (\code{term}),
        p-values (\code{p.value}) and standard errors (\code{std.error}).
}
\description{
This function returns the p-values for fitted model objects.
}
\details{
For linear mixed models (\code{lmerMod}-objects), the computation of
        p-values (if \code{p.kr = TRUE}) is based on conditional F-tests
        with Kenward-Roger approximation for the df, using the
        \CRANpkg{pbkrtest}-package. If \pkg{pbkrtest} is not available or
        \code{p.kr = FALSE}, or if \code{x} is a \code{glmerMod}-object,
        computation of p-values is based on normal-distribution assumption,
        treating the t-statistics as Wald z-statistics.
        \cr \cr
        If p-values already have been computed (e.g. for \code{merModLmerTest}-objects
        from the \CRANpkg{lmerTest}-package), these will be returned.
        \cr \cr
        The \code{print()}-method has a \code{summary}-argument, that - in
        case \code{p.kr = TRUE} - also prints information on the approximated
        degrees of freedom (see 'Examples').
}
\examples{
data(efc)
# linear model fit
fit <- lm(neg_c_7 ~ e42dep + c172code, data = efc)
p_value(fit)

# Generalized Least Squares fit
library(nlme)
fit <- gls(follicles ~ sin(2*pi*Time) + cos(2*pi*Time), Ovary,
           correlation = corAR1(form = ~ 1 | Mare))
p_value(fit)

# lme4-fit
library(lme4)
sleepstudy$mygrp <- sample(1:45, size = 180, replace = TRUE)
fit <- lmer(Reaction ~ Days + (1 | mygrp) + (1 | Subject), sleepstudy)
pv <- p_value(fit, p.kr = TRUE)

# normal output
pv

# add information on df and t-statistic
print(pv, summary = TRUE)

}
