% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skeleSim.classes.R
\docType{class}
\name{skeleSim.classes}
\alias{skeleSim.classes}
\alias{skeleSim.params}
\alias{skeleSim.params-class}
\alias{scenario.params-class}
\alias{scenario.params}
\title{skeleSim Parameters Class}
\description{
An S4 class storing generic parameters used throughout
  the workflow
}
\section{Slots}{

\describe{
\item{\code{title}}{a title for the simulation. Used in labelling of output files.}

\item{\code{date}}{datestamp for the simulation.}

\item{\code{quiet}}{logical determining whether to limit progress reports.}

\item{\code{question}}{a single character representing type of analytical question
being addressed. Can be one of: (n)ull, p(o)wer, (p)erformance.}

\item{\code{simulator.type}}{a single character representing which type of simulator
to use. Can be one of: (c)oalescent or (f)orward-time.}

\item{\code{simulator}}{a three character code representing which simulator is being run.
Currently codes for fastsimcoal(fsc) and rmetasim(rms) exist.}

\item{\code{scenarios}}{a list of \code{scenario.params} objects.}

\item{\code{num.sim.reps}}{number of replicates to run.}

\item{\code{sim.func}}{a function that runs one replicate of the simulator.
Must take and return only a \code{skeleSim.params} object.}

\item{\code{current.scenario}}{number of current scenario being run.}

\item{\code{current.replicate}}{number of current replicate within current scenario being run.}

\item{\code{rep.sample}}{result of last call to \code{sim.func}.}

\item{\code{rep.analysis.func}}{a function that analyzes the results of one
simulation replicate.}

\item{\code{num.perm.reps}}{number of permutation replicates to run for population structure
statistics.}

\item{\code{rep.result}}{result from last call to \code{rep.analysis.func}.}

\item{\code{analysis.results}}{a matrix containing result of all replicate analyses.}

\item{\code{sim.summary.func}}{a function to summarize \code{rep.analysis}.}

\item{\code{summary.results}}{a list containign result from call to
\code{sim.summary.func}.}

\item{\code{sim.check.func}}{a function to check the parameters object prior to
running the simualtions}

\item{\code{sim.scen.checks}}{a matrix containing results of 'checks' on scenario elements (T/F)}

\item{\code{timing}}{list containing elapsed time for a simulation}

\item{\code{other.checks}}{a vector containing results of 'checks' on other param object elements}

\item{\code{scenario.reps}}{a two column matrix describing which iteration matches
which scenario/replicate}

\item{\code{analyses.requested}}{vector of logicals specifying "Global", "Locus",
or "Pairwise" analyses have been requested.}

\item{\code{num.pops}}{number of populations.}

\item{\code{pop.size}}{a vector \code{num.pop} long giving size of each population.}

\item{\code{sample.size}}{a vector \code{num.pop} long giving the number of
samples to take from each population.}

\item{\code{migration}}{a list of one or more \code{num.pop} x \code{num.pop} matrices
giving the migration rates between each population.}

\item{\code{locus.type}}{a character representation of what type of marker to simulate.
Can be "dna", "msat", or "snp".}

\item{\code{mig.helper}}{a list of flags and values that are needed for the shiny interface but are not needed for the simulation
itself.  Makes it easier to keep track of different ways to specify migration matrices for different scenarios.
List elements will include migration model, rows and columns of landscape and distance function.}

\item{\code{num.loci}}{number of msat or snp loci to simulate.}

\item{\code{sequence.length}}{number of DNA base pairs to use.}

\item{\code{mut.rate}}{mutation rate for DNA or msat.}

\item{\code{simulator.params}}{an object storing simulator-specific parameters. Can
be a list or a simulator-specific class.}
}}

