% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{qcat}
\alias{qcat}
\title{Compute the quantile function for a categorical distribution.}
\usage{
qcat(pr, p, lower.tail = TRUE, log.pr = FALSE)
}
\arguments{
\item{pr}{vector of probabilities.}

\item{p}{vector of proabilities.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P(X \le  x)}, otherwise, \eqn{P(X > x)}.}

\item{log.pr}{logical; if TRUE, probabilities \eqn{pr} are handled as log\eqn{(pr)}.}
}
\value{
\code{qcat} returns a vector of quantiles.
}
\description{
Compute the quantile function for a categorical distribution.
}
\details{
This function computes quantiles for the categorical distribution with support \eqn{1, \dots , K} and probabilities \eqn{p = (p_1, \dots , p_K)'}.
}

