% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime_wfs_multibestmodel.R
\name{modeltime_wfs_multibestmodel}
\alias{modeltime_wfs_multibestmodel}
\title{Get the best workflow for each time series}
\usage{
modeltime_wfs_multibestmodel(.table, .metric = NULL, .minimize = TRUE)
}
\arguments{
\item{.table}{a tibble that comes from the output of the \code{modeltime_wfs_multifit()} or \code{modeltime_wfs_multiforecast()}
functions. For the \code{modeltime_wfs_multifit()} function, the 'table_time' object must be selected
from the output.}

\item{.metric}{a string of evaluation metric, the following symmetrical can be supplied: 'mae', 'mape','mase',
'smape','rmse','rsq'.}

\item{.minimize}{boolean (default = TRUE), TRUE if the error metric should be minimized, FALSE in order to maximize it.}
}
\value{
a tibble, corresponds to the same tibble supplied in the '.table' parameter but with the
selection of the best workflow for each series.
}
\description{
obtains the best workflow for each time series based on a performance metric.
}
\examples{
library(dplyr)
library(earth)

df <- sknifedatar::emae_series

datex <- '2020-02-01'
df_emae <- df \%>\%
  dplyr::filter(date <= datex) \%>\% 
  tidyr::nest(nested_column=-sector) \%>\% 
  head(2)

receta_base <- recipes::recipe(value ~ ., data = df \%>\% select(-sector))

mars <- parsnip::mars(mode = 'regression') \%>\% parsnip::set_engine('earth')

wfsets <- workflowsets::workflow_set(
  preproc = list(
    R_date = receta_base),
  models  = list(M_mars = mars),
  cross   = TRUE)

wfsets_fit <- modeltime_wfs_multifit(.wfs = wfsets,
                                     .prop = 0.8, 
                                     serie = df_emae)

sknifedatar::modeltime_wfs_multibestmodel(.table = wfsets_fit$table_time,
                                          .metric = "rmse",
                                          .minimize = TRUE)

}
