% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{slackrBot}
\alias{slackrBot}
\title{Output R expressions to a \code{slack.com} channel/user (as \code{slackbot})}
\usage{
slackrBot(..., channel = Sys.getenv("SLACK_CHANNEL"),
  username = Sys.getenv("SLACK_USERNAME"),
  icon_emoji = Sys.getenv("SLACK_ICON_EMOJI"),
  incoming_webhook_url = Sys.getenv("SLACK_INCOMING_URL_PREFIX"),
  token = Sys.getenv("SLACK_TOKEN"))
}
\arguments{
\item{...}{expressions to be sent to Slack.com}

\item{channel}{which channel to post the message to (chr)}

\item{username}{what user should the bot be named as (chr)}

\item{icon_emoji}{what emoji to use (chr) \code{""} will mean use the default}

\item{incoming_webhook_url}{which \url{slack.com} API endpoint URL to use}

\item{token}{your webhook API token}
}
\description{
Takes an \code{expr}, evaluates it and sends the output to a \url{slack.com}
chat destination. Useful for logging, messaging on long compute tasks or
general information sharing.
}
\details{
By default, everyting but \code{expr} will be looked for in a "\code{SLACK_}"
environment variable. You can override or just specify these values directly instead,
but it's probably better to call \link{slackrSetup} first.

This function uses the incoming webhook API and posts user messages as \code{slackbot}
}
\note{
You need a \url{slack.com} account and will also need to setup an incoming webhook: \url{https://api.slack.com/}
}
\examples{
\dontrun{
slackrSetup()
slackr("iris info", head(iris), str(iris))
}
}
\seealso{
\code{\link{slackrSetup}}, \code{\link{slackr}}, \code{\link{dev.slackr}}, \code{\link{save.slackr}}, \code{\link{slackrUpload}}
}

