% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.R
\name{gof}
\alias{gof}
\alias{gof.slca}
\title{Goodness of Fit Test for Estimated \code{slca} Model}
\usage{
gof(object, ...)

\method{gof}{slca}(
   object, ..., test = c("none", "chisq", "boot"),
   nboot = 100, plot = FALSE,
   maxiter = 100, tol = 1e-6, verbose = FALSE
)
}
\arguments{
\item{object}{an object of class \code{slca} and \code{estimated}.}

\item{...}{additional objects of class \code{slca} and \code{estimated}.}

\item{test}{a character string specifying the type of test to be conducted. If \code{"chisq"}, a chi-squared test is conducted. If \code{"boot"}, a bootstrap test is conducted.}

\item{nboot}{an integer specifying the number of bootstrap rounds to be performed.}

\item{plot}{a logical value indicating whether to print histogram of G-squared statistics for boostrap samples, only for \code{test = "boot"}.}

\item{maxiter}{an integer specifying maximum number of iterations allowed for the estimation process of each bootstrapping round.}

\item{tol}{a numeric value setting tolerance for the convergence of each bootstrapping round.}

\item{verbose}{a logical value indicating whether to print progress updates on the number of bootstrapping rounds completed.}
}
\value{
A \code{data.frame} containing the number of parameters (Df), loglikelihood, AIC, BIC, G-squared statistics, and the residual degree of freedom for each object.
Depending on the \code{test} argument, the p-value for the corresponding statistical test may also be included.
}
\description{
Provides AIC, BIC and deviance statistic (G-squared) for goodness of fit test for the fitted model. Absolute model fit can be tested with deviance statistics, if \code{test} argument is specified.
}
\examples{
library(magrittr)
data <- gss7677[gss7677$COHORT == "YOUNG", ]
stat2 <- slca(status(2) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat3 <- slca(status(3) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat4 <- slca(status(4) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))

gof(stat2, stat3, stat4)
gof(stat2, stat3, stat4, test = "chisq")
\donttest{
gof(stat2, stat3, stat4, test = "boot")
}

compare(stat3, stat4)
compare(stat3, stat4, test = "chisq")
\donttest{
compare(stat3, stat4, test = "boot")
}
}
\seealso{
\link[slca]{compare}
}
