% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_league_information_table.R
\name{plot_league_information_table}
\alias{plot_league_information_table}
\title{Plot League Information Table}
\usage{
plot_league_information_table(
  league_id,
  font_color = "inherit",
  win_loss_fill = "RdYlGn",
  fpts_for_fill = "lightgreen",
  fpts_against_fill = "#f68383"
)
}
\arguments{
\item{league_id}{League ID generated from Sleeper (numeric).}

\item{font_color}{Font color, hex code or name (string).}

\item{win_loss_fill}{String describing the brewer.pal color palette selection. Can see all options through RColorBrewer::display.brewer.all() (string).}

\item{fpts_for_fill}{Bar color, name or hex, for each fantasy points for cell by team (string).}

\item{fpts_against_fill}{Bar color, name or hex, for each fantasy points against cell by team (string).}
}
\value{
Returns a table containing team names and
        their associated statistics.
}
\description{
Given the league ID, generate a table showing team names and
their associated statistics (wins, losses, points for/against, etc.).
}
\examples{
\dontrun{plot_league_information_table(688281863499907072)}
\dontrun{plot_league_information_table(688281863499907072, font_color = "#ee5050")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, January 2024
}
\keyword{information}
\keyword{league}
\keyword{statistics}
