% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline2ph.R
\name{spline2ph}
\alias{spline2ph}
\title{Splines for two-phase regression functions}
\usage{
spline2ph(
  x,
  data,
  size = 20,
  degree = 3,
  bs_names,
  group = NULL,
  split_group = TRUE
)
}
\arguments{
\item{x}{Column names of the covariate of the dataset.}

\item{data}{Specifies the name of the dataset. This argument is required.}

\item{size}{Pass on to the \code{df} argument in \code{splines::bs()}. Degrees of freedom for EACH variable.}

\item{degree}{Pass on to the \code{degree} argument in \code{splines::bs()}. Degree of the piecewise polynomial. Default is 3 for cubic splines.}

\item{bs_names}{Column names of the output B-spline basis matrix.}

\item{group}{Optional. Column name of the categorical variable of which might have heterogeneous errors among different groups.}

\item{split_group}{Optional. Whether to split by group proportion for the group with B-spline size if the \code{group} argument is provided. If \code{FALSE}, then the split will be averaged across all groups. Default is \code{TRUE}.}
}
\value{
the \code{data.frame} object including the original dataset and the B-spline bases.
}
\description{
Creates splines for two-phase regression function in this package, including \code{linear2ph}, \code{logistic2ph}, \code{cv_linear2ph}, \code{cv_logistic2ph}.
}
\details{
This function can be directly applied for regression model with one or more error-prone continuous covariates.
}
\examples{
# example code
data("mock.vccc")
sn <- 20
b_spline_names <- paste0("bs", 1:sn)
data.linear <- spline2ph(x = "VL_unval", data = mock.vccc, size = sn,
                         degree = 3,  bs_names = b_spline_names,
                         group = "Sex")

}
