% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compilation.R
\name{read_model}
\alias{read_model}
\title{Read a previously serialized model configuration}
\usage{
read_model(path)
}
\arguments{
\item{path}{Directory with all required configuration files}
}
\value{
Compiled \code{slendr_model} model object which encapsulates all
information about the specified model (which populations are involved,
when and how much gene flow should occur, what is the spatial resolution
of a map, and what spatial dispersal and mating parameters should be used
in a SLiM simulation, if applicable)
}
\description{
Reads all configuration tables and other model data from a location
where it was previously compiled to by the \code{compile} function.
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
path <- system.file("extdata/models/introgression", package = "slendr")
model <- read_model(path)

plot_model(model, sizes = FALSE, log = TRUE)
}
