% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree-sequences.R
\name{ts_genotypes}
\alias{ts_genotypes}
\title{Extract genotype table from the tree sequence}
\usage{
ts_genotypes(ts)
}
\arguments{
\item{ts}{Tree sequence object of the class \code{slendr_ts}}
}
\value{
Data frame object of the class \code{tibble} containing genotypes
of simulated individuals in columns
}
\description{
Extract genotype table from the tree sequence
}
\examples{
\dontshow{check_dependencies(python = TRUE) # make sure dependencies are present
}
# load an example model with an already simulated tree sequence
slendr_ts <- system.file("extdata/models/introgression.trees", package = "slendr")
model <- read_model(path = system.file("extdata/models/introgression", package = "slendr"))

# load the tree-sequence object from disk
ts <- ts_load(slendr_ts, model, simplify = TRUE, mutate = TRUE,
              mutation_rate = 1e-8, random_seed = 42)

# extract the genotype matrix (this could take  a long time consume lots
# of memory!)
gts <- ts_genotypes(ts)
}
