% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_model}
\alias{plot_model}
\title{Plot demographic history encoded in a slendr model}
\usage{
plot_model(
  model,
  sizes = TRUE,
  proportions = FALSE,
  gene_flow = TRUE,
  log = FALSE,
  order = NULL,
  file = NULL,
  samples = NULL,
  ...
)
}
\arguments{
\item{model}{Compiled \code{slendr_model} model object}

\item{sizes}{Should population size changes be visualized?}

\item{proportions}{Should gene flow proportions be visualized (\code{FALSE}
by default to prevent cluttering and overplotting)}

\item{gene_flow}{Should gene-flow arrows be visualized (default \code{TRUE}).}

\item{log}{Should the y-axis be plotted on a log scale? Useful for models
over very long time-scales.}

\item{order}{Order of the populations along the x-axis, given as a character
vector of population names. If \code{NULL} (the default), the default plotting
algorithm will be used, ordering populations from the most ancestral to the
most recent using an in-order tree traversal.}

\item{file}{Output file for a figure saved via \code{ggsave}}

\item{samples}{Sampling schedule to be visualized over the model}

\item{...}{Optional argument which will be passed to \code{ggsave}}
}
\value{
A ggplot2 object with the visualized slendr model
}
\description{
Plot demographic history encoded in a slendr model
}
\examples{
\dontshow{check_dependencies(python = TRUE, quit = TRUE) # dependencies must be present
}
init_env()

# load an example model with an already simulated tree sequence
path <- system.file("extdata/models/introgression", package = "slendr")
model <- read_model(path)

plot_model(model, sizes = FALSE, log = TRUE)
}
