% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{Slurm_env}
\alias{Slurm_env}
\title{A wrapper of \link{Sys.getenv}}
\usage{
Slurm_env(x)
}
\arguments{
\item{x}{Character scalar. Environment variable to get.}
}
\value{
If slurm is available and the R session is running under a job
array, meaning that \code{SLURM_ARRAY_TASK_ID} is defined, then it returns that
value, otherwise it will return \code{1}.
}
\description{
This function is used within the R script written by \code{slurmR} to get the
current value of \code{SLURM_ARRAY_TASK_ID}, an environment variable that Slurm
creates when running an array. In the case that \code{opts_slurmR$get_debug() == TRUE},
the function will return a 1 (see \link{opts_slurmR}).
}
\seealso{
Other utilities: 
\code{\link{Slurm_clean}()},
\code{\link{Slurm_log}()},
\code{\link{WhoAmI}()},
\code{\link{parse_flags}()},
\code{\link{snames}()},
\code{\link{status}()}
}
\concept{utilities}
