% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscript.R
\name{new_rscript}
\alias{new_rscript}
\title{General purpose function to write R scripts}
\usage{
new_rscript(
  njobs,
  tmp_path,
  job_name,
  pkgs = list_loaded_pkgs(),
  libPaths = .libPaths()
)
}
\arguments{
\item{njobs}{Integer. Number of jobs to use in the job-array. This specifies
the number of R sessions to initialize. This does not specify the number of
cores to be used.}

\item{tmp_path}{Character. Path to the directory where all the data (including
scripts) will be stored. Notice that this path must be accessible by all the
nodes in the network (See \link{opts_slurmR}).}

\item{job_name}{Character. Name of the job to be passed to \code{Slurm}.}

\item{pkgs}{A named list with packages to be included. Each element of the list
must be a path to the R library, while the names of the list are the names of
the R packages to be loaded.}

\item{libPaths}{A character vector. See \link{.libPaths}.}
}
\value{
An environment of class \code{slurmR_rscript}. This has the following accessible
components:
\itemize{
\item \code{add_rds} Add rds files to be loaded in each job.", \code{x} is a named list
with the objects that should be loaded in the jobs. If \code{index = TRUE} the
function assumes that the user will be accessing a particular subset of \code{x}
during the job, which is accessed according to \code{INDICES[[ARRAY_ID]]}. The
option \code{compress} is passed to \link{saveRDS}.

One important side effect is that when this function is called, the object
will be saved in the current job directory, this is \code{opts_slurmR$get_tmp_path()}.
\item \code{append} Adds a line to the R script. Its only argument, \code{x} is a character
vector that will be added to the R script.
\item \code{rscript} A character vector. This is the actual R script that will be written
at the end.
\item \code{finalize} Adds the final line of the R script. This function receives a
character scalar \code{x} which is used as the name of the object to be saved.
If missing, the function will save a NULL object. The \code{compress} argument
is passed to \link{saveRDS}.
\item \code{set_seed} Adds a vector of seeds to be used across the jobs. This vector
of seeds should be of length \code{njobs}. The other two parameters of the
function are passed to \link{set.seed}. By default the seed is picked as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{seeds <- sample.int(.Machine$integer.max, njobs, replace = FALSE)
}\if{html}{\out{</div>}}
\item \code{write} Finalizes the process by writing the R script in the corresponding
folder to be used with Slurm.
}
}
\description{
This function will create an object of class \code{slurmR_rscript} that can be used
to write the R component in a batch job.
}
