% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icExploreGen.R
\name{icExploreGen}
\alias{icExploreGen}
\title{Exploring initial configurations in an agnostic way}
\usage{
icExploreGen(
  object,
  mdscall = NULL,
  conflist,
  nrep = 100,
  ndim,
  returnfit = FALSE,
  min = -5,
  max = 5,
  verbose = FALSE
)
}
\arguments{
\item{object}{A fitted object of class 'smacofP', 'smacofB' or 'smacof'. If supplied this takes precedence over the call argument. If given this is added to the output and may be the optimal one.}

\item{mdscall}{Alternatively to a fitted object, one can pass a syntactically valid call for any of the MDS functions cops, stops or smacof that find a configuration (not the ones that do parameter selection like pcops or stops). If object and call is given, object takes precedence.}

\item{conflist}{Optional list of starting configurations.}

\item{nrep}{If conflist is not supplied, how many random starting configurations should be used.}

\item{ndim}{Dimensions of target space.}

\item{returnfit}{Should all fitted MDS be returned. If FALSE (default) none is returned.}

\item{min}{lower bound for the uniform distribution to sample from}

\item{max}{upper bound for the uniform distribution to sample from}

\item{verbose}{If >0 prints the fitting progress.}
}
\value{
an object of class 'icexplore', see \code{\link[smacof]{icExplore}} for more. There is a plot method in package 'smacof'.
}
\description{
Allows to user to explore the effect of various starting configurations when fitting an MDS model. This is a bit more general than the icExplore function in smacof, as we allow any PS model to be used as the model is either setup by call or by a prefitted object (for the models in cops and stops we do not have a single UI function which necessitates this). Additionally, one can supply their own configurations and not just random ones.
}
\details{
If no configuration list is supplied, then nrep configurations are simulated. They are drawn from a ndim-dimensional uniform distribution with minimum min and maximum max. We recommend to use the route via supplying a fitted model as these are typically starting from a Torgerson configuration and are likely quite good.
}
\examples{

dis<-smacof::kinshipdelta

## Version 1: Using a fitted object (recommended)
res1<-rStressMin(delta=dis,type="ordinal",itmax=100)
resm<-icExploreGen(res1,nrep=5)

## Version 2: Using a call object and supplying conflist
conflist<-list(res1$init,jitter(res1$init,1),jitter(res1$init,1),jitter(res1$init,1))
c1 <- call("smds",delta=dis,tau=0.2,itmax=100)
resm<-icExploreGen(mdscall=c1,conflist=conflist,returnfit=TRUE)

plot(resm)

}
