% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{knn}
\alias{knn}
\title{K nearest neighbors}
\usage{
knn(coords, longlat = FALSE, k = 1, d = NULL)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used.If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{k}{An integer indicating the maximum number of regions to inclue in a potential cluster.  Default is 10}

\item{d}{An n by n distance matrix.  If provided,
this is used instead of computing \code{d} based on
\code{coords} and \code{longlat}.}
}
\value{
An \eqn{n \times k} matrix of nearest neighbors.
}
\description{
\code{knn} returns the k nearest neighbors of the
n coordinates in \code{coords}.  The nearest neighbors
are constructed to be self-inclusive, i.e., an
observations is its closest neighbor.
}
\examples{
data(nydf)
coords = nydf[,c("longitude", "latitude")]
knn(coords, longlat = TRUE, k = 4)
}
