% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex.zones.R
\name{flex.zones}
\alias{flex.zones}
\title{Determine zones for flexibly shaped spatial scan test}
\usage{
flex.zones(coords, w, k = 10, longlat = FALSE, cl = NULL,
  loop = FALSE, verbose = FALSE, pfreq = 1)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions.}

\item{w}{A binary spatial adjacency matrix for the regions.}

\item{k}{An integer indicating the maximum number of regions to inclue in a potential cluster.  Default is 10}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used.If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link[parallel]{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{loop}{A logical value indicating whether a loop
should be used to implement the function instead of
\code{\link[pbapply]{pbapply}}.  The default is
\code{FALSE}. If \code{TRUE}, then memory-saving steps
are also taken.}

\item{verbose}{A logical value indicating whether
progress messages should be provided.
The default is \code{FALSE}.  If both \code{loop} and
\code{verbose} are \code{TRUE}, informative messages
are displayed that can be useful for diagnosing where
the sequences of connected subgraphs are slowing down
or having problems.}

\item{pfreq}{The frequency that messages are reported
from the loop (if \code{verbose = TRUE}). The default
is \code{pfreq = 1}, meaning a message is returned for
each index of the loop.}
}
\value{
Returns a list of zones to consider for
  clustering.  Each element of the list contains a vector
  with the location ids of the regions in that zone.
}
\description{
\code{flex.zones} determines the unique zones to consider
for the flexibly shaped spatial scan test of Tango and
Takahashi (2005).  The algorithm uses a breadth-first
search to find all subgraphs connected to each vertex
(region) in the data set of size \eqn{k} or less.
}
\examples{
data(nydf)
data(nyw)
coords = cbind(nydf$x, nydf$y)
zones = flex.zones(coords, w = nyw, k = 3)
\dontrun{
# see what happens when verbose = TRUE
zones = flex.zones(coords, w = nyw, k = 3, verbose = TRUE)
}
}
\references{
Tango, T., & Takahashi, K. (2005). A flexibly
  shaped spatial scan statistic for detecting clusters.
  International journal of health geographics, 4(1), 11.
}
\author{
Joshua French
}
