% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mof.zdt4.R
\name{makeZDT4Function}
\alias{makeZDT4Function}
\title{ZDT4 Function}
\usage{
makeZDT4Function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the two-objective ZDT4 test problem. For \eqn{m} objective it
is defined as follows
\deqn{f(\mathbf{x}) = \left(f_1(\mathbf{x}_1), f_2(\mathbf{x})\right)}
with
\deqn{f_1(\mathbf{x}_1) = \mathbf{x}_1, f_2(\mathbf{x}) = g(\mathbf{x}) h(f_1(\mathbf{x}_1), g(\mathbf{x}))}
where
\deqn{g(\mathbf{x}) = 1 + 10 (m - 1) + \sum_{i = 2}^{m} (\mathbf{x}_i^2 - 10\cos(4\pi\mathbf{x}_i)), h(f_1, g) = 1 - \sqrt{\frac{f_1(\mathbf{x})}{g(\mathbf{x})}}}
and \eqn{\mathbf{x}_i \in [0,1], i = 1, \ldots, m}.
This function has many Pareto-optimal fronts and is thus suited to test the
algorithms ability to tackle multimodal problems.
}
\references{
E. Zitzler, K. Deb, and L. Thiele. Comparison of Multiobjective
Evolutionary Algorithms: Empirical Results. Evolutionary Computation, 8(2):173-195, 2000
}

