% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{conversion}
\alias{conversion}
\alias{convertToMaximization}
\alias{convertToMinimization}
\title{Conversion between minimization and maximization problems.}
\usage{
convertToMaximization(fn)

convertToMinimization(fn)
}
\arguments{
\item{fn}{[\code{smoof_function}]\cr
Smoof function.}
}
\value{
[\code{smoof_function}]
}
\description{
We can minimize f by maximizing -f. The majority of predefined objective functions
in \pkg{smoof} should be minimized by default. However, there is a handful of
functions, e.g., Keane or Alpine02, which shall be maximized by default.
For benchmarking studies it might be beneficial to inverse the direction.
The functions \code{convertToMaximization} and \code{convertToMinimization}
do exactly that keeping the attributes.
}
\note{
Both functions will quit with an error if multi-objective functions are passed.
}
\examples{
# create a function which should be minimized by default
fn = makeSphereFunction(1L)
print(shouldBeMinimized(fn))
# Now invert the objective direction ...
fn2 = convertToMaximization(fn)
# and invert it again
fn3 = convertToMinimization(fn2)
# Now to convince ourselves we render some plots
opar = par(mfrow = c(1, 3))
plot(fn)
plot(fn2)
plot(fn3)
par(opar)
}
