% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_ci.R
\name{sm_ci}
\alias{sm_ci}
\title{Confidence interval}
\usage{
sm_ci(data, alpha = 0.05, low = TRUE)
}
\arguments{
\item{data}{Numerical vector of data}

\item{alpha}{Default is set to 0.05, so that 95\% confidence interval is computed.}

\item{low}{If its TRUE, it will compute the low tail of the confidence interval.
If its FALSE, it will compute the high tail of the confidence interval.}
}
\value{
Prints a double vector that is a single end of the specified confidence interval.
}
\description{
This function computes the confidence interval.
}
\examples{
library(smplot2)
set.seed(1)

a <- rnorm(100,1,1)
sm_ci(a)
sm_ci(a, low=FALSE)

}
