% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_put_together.R
\name{sm_put_together}
\alias{sm_put_together}
\title{Combining figures together}
\usage{
sm_put_together(
  all_plots,
  title,
  xlabel,
  ylabel,
  legend,
  ncol,
  nrow,
  xlabel2,
  ylabel2,
  tickRatio,
  panel_scale = 0.9,
  wRatio = 1.1,
  hRatio = 1.1,
  hmargin = 0,
  wmargin = 0,
  remove_ticks = "some",
  wRatio2 = 1.1,
  hRatio2 = 1.1
)
}
\arguments{
\item{all_plots}{all_plots should be list, which should contain all panels
that are to be combined into one figure.}

\item{title}{Title layer that will determine the main title of the combined plot.
This is created using sm_common_title(). Optional argument.}

\item{xlabel}{xlabel layer that will determine the label of the combined plot's x-axis.
This is created using sm_common_xlabel(). Optional argument.}

\item{ylabel}{ylabel layer that will determine the label of the combined plot's y-axis.
This is created using sm_common_ylabel(). Optional argument.}

\item{legend}{ggplot() layer that has legend. Optional argument.}

\item{ncol}{Number of columns in the combined plot}

\item{nrow}{Number of rows in the combined plot}

\item{xlabel2}{2nd xlabel layer that will determine the label of the combined plot's secondary x-axis.
This is created using sm_common_xlabel(). Optional argument.}

\item{ylabel2}{2nd ylabel layer that will determine the label of the combined plot's y-axis.
This is created using sm_common_ylabel(). Optional argument.}

\item{tickRatio}{Relative size of the ticks to the default aesthetics of the thematic functions (ex. sm_hgrid()).
If there are more rows or columns, please increase the tickRatio (1.4 - 1.8).}

\item{panel_scale}{Scale of the panel. Default is set to 0.9 to reduce empty space
within and around each panel. The user can set to a value from 0 to 1 to
see what happens to the spacing within each panel and between panels.}

\item{wRatio}{This adjusts the ratio of the width of the first column to those of other columns.
By default, it is set to be 1.1x wider than that of other columns. If the value
is larger than 1, then it will be wider than that of other columns. Users are encouraged
to adjust this value because different computers can show different looking outputs.}

\item{hRatio}{This adjusts the ratio of the height of the last row to those of other rows
By default, it is set to be 1.1x taller than that of other columns. If the value
is larger than 1, then it will be taller than that of other columns. Users are encouraged
to adjust this value because different computers can show different looking outputs.}

\item{hmargin}{The amount of height of blank space between subplots. It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 0. If its positive, the blank spacing will increase. If its negative, it will get reduced
between panels.}

\item{wmargin}{The amount of width of blank space between subplots. It sets the size of the empty space (i.e., margin) between panels. T
he default is set to 0. If its positive, the blank spacing will increase. If its negative, it will get reduced
between panels.}

\item{remove_ticks}{If set to 'some', x-axis ticks and y-axis ticks will be removed in inner plots.
If set to 'all', then all panels' ticks will be removed.
If set to 'none', then all panels' ticks will be kept.}

\item{wRatio2}{This adjusts the ratio of the width of the last column to those of other columns.
By default, if ylabel2 is provided, it is set to be 1.1x wider than that of other columns. If the value
is larger than 1, then it will be wider than that of other columns. Users are encouraged
to adjust this value because different computers can show different looking outputs.}

\item{hRatio2}{This adjusts the ratio of the height of the first row to those of other rows
By default, if xlabel2 is provided, it is set to be 1.1x taller than that of other columns. If the value
is larger than 1, then it will be taller than that of other columns. Users are encouraged
to adjust this value because different computers can show different looking outputs.}
}
\value{
Returns a combined figure.
}
\description{
Combining figures together
}
\examples{
library(smplot2)
library(ggplot2)

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
geom_point(shape = 21, fill = '#0f993d', color = 'white',
          size = 3) -> p1

ggplot(data = mtcars, mapping = aes(x = drat, y = mpg)) +
  geom_point(shape = 21, fill = '#0f993d', color = 'white', size = 3) +
  sm_hvgrid() -> p2

title <- sm_common_title('My title')
xlabel <- sm_common_xlabel('My x-axis')
ylabel <- sm_common_ylabel('My y-axis')

sm_put_together(list(p1,p2), title=title, xlabel=xlabel,
                ylabel=ylabel, ncol=2,nrow=1)

}
