% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVD.pls.R
\name{SVD.pls}
\alias{SVD.pls}
\title{Partial Least Squares Regression via SVD (Internal)}
\usage{
SVD.pls(x, y, n.components = NULL)
}
\arguments{
\item{x}{A numeric matrix or data frame of predictors (X). Should have dimensions n × p.}

\item{y}{A numeric matrix or data frame of response variables (Y). Should have dimensions n × q.}

\item{n.components}{Integer specifying the number of PLS components to extract. If NULL, defaults to \code{qr(x)$rank}.}
}
\value{
A list containing:
\describe{
  \item{model.type}{Character string indicating the model type ("PLS Regression").}
  \item{T}{Matrix of predictor scores (n × H).}
  \item{U}{Matrix of response scores (n × H).}
  \item{W}{Matrix of predictor weights (p × H).}
  \item{C}{Matrix of normalized response weights (q × H).}
  \item{P_loadings}{Matrix of predictor loadings (p × H).}
  \item{Q_loadings}{Matrix of response loadings (q × H).}
  \item{B_vector}{Vector of scalar regression weights (length H).}
  \item{coefficients}{Matrix of final regression coefficients in the original scale (p × q).}
  \item{intercept}{Vector of intercepts (length q). All zeros due to centering.}
  \item{X_explained}{Percent of total X variance explained by each component.}
  \item{Y_explained}{Percent of total Y variance explained by each component.}
  \item{X_cum_explained}{Cumulative X variance explained.}
  \item{Y_cum_explained}{Cumulative Y variance explained.}
}
}
\description{
This function is called internally by \code{\link{pls.regression}} and is not intended
to be used directly. Use \code{pls.regression(..., calc.method = "SVD")} instead.

Performs Partial Least Squares (PLS) regression using the Singular Value Decomposition (SVD)
of the cross-covariance matrix. This method estimates the latent components by identifying directions
in the predictor and response spaces that maximize their covariance, using the leading singular vectors
of the matrix \eqn{R = X^\top Y}.
}
\details{
The algorithm begins by z-scoring both \code{x} and \code{y} (centering and scaling to unit variance).
The initial residual matrices are set to the scaled values: \code{E = X_scaled}, \code{F = Y_scaled}.

For each component h = 1, ..., H:
\enumerate{
  \item Compute the cross-covariance matrix \eqn{R = E^\top F}.
  \item Perform SVD on \eqn{R = U D V^\top}.
  \item Extract the first singular vectors: \eqn{w = U[,1]}, \eqn{q = V[,1]}.
  \item Compute scores: \eqn{t = E w} (normalized), \eqn{u = F q}.
  \item Compute loadings: \eqn{p = E^\top t}, regression scalar \eqn{b = t^\top u}.
  \item Deflate residuals: \eqn{E \gets E - t p^\top}, \eqn{F \gets F - b t q^\top}.
}

After all components are extracted, a post-processing step removes components with zero regression
weight. The scaled regression coefficients are computed using the Moore–Penrose pseudoinverse of the
loading matrix \eqn{P}, and then rescaled to the original variable units.
}
\examples{
\dontrun{
X <- matrix(rnorm(100 * 10), 100, 10)
Y <- matrix(rnorm(100 * 2), 100, 2)
model <- pls.regression(X, Y, n.components = 3, calc.method = "SVD")
model$coefficients
}

}
\references{
Abdi, H., & Williams, L. J. (2013). Partial least squares methods: Partial least squares correlation and partial least square regression. \emph{Methods in Molecular Biology (Clifton, N.J.)}, 930, 549–579. \doi{10.1007/978-1-62703-059-5_23}

de Jong, S. (1993). SIMPLS: An alternative approach to partial least squares regression. \emph{Chemometrics and Intelligent Laboratory Systems}, 18(3), 251–263. \doi{10.1016/0169-7439(93)85002-X}
}
\keyword{internal}
