% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\docType{data}
\name{colors}
\alias{colors}
\alias{Deep.Red}
\alias{Dark.Red}
\alias{Red}
\alias{Light.Red}
\alias{Pale.Red}
\alias{Deep.Orange}
\alias{Dark.Orange}
\alias{Orange}
\alias{Light.Orange}
\alias{Pale.Orange}
\alias{Deep.Yellow}
\alias{Dark.Yellow}
\alias{Yellow}
\alias{Light.Yellow}
\alias{Pale.Yellow}
\alias{Deep.Green}
\alias{Dark.Green}
\alias{Green}
\alias{Light.Green}
\alias{Pale.Green}
\alias{Deep.Blue}
\alias{Dark.Blue}
\alias{Blue}
\alias{Light.Blue}
\alias{Pale.Blue}
\alias{Deep.Purple}
\alias{Dark.Purple}
\alias{Purple}
\alias{Light.Purple}
\alias{Pale.Purple}
\alias{Deep.Grey}
\alias{Dark.Grey}
\alias{Grey}
\alias{Light.Grey}
\alias{Pale.Grey}
\alias{color.list}
\title{SnazzieR Color Palette}
\format{
Each color is a character string representing a hex code.

An object of class \code{character} of length 1.

An object of class \code{list} of length 35.
}
\usage{
color.list
}
\description{
A collection of named hex colors grouped by hue and tone.
Each color is available as an exported object (e.g., \code{Red}, \code{Dark.Red}).
}
\details{
\if{html}{
<table style='width:100%; font-family: monospace; border-collapse: collapse;'>
<tr><th align='left'>Name</th><th align='left'>Hex</th><th align='left'>Swatch</th></tr>
<tr><td>Dark.Red</td><td>#9F193D</td><td><img src='figures/Dark.Red.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Red</td><td>#C31E4A</td><td><img src='figures/Red.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Red</td><td>#E66084</td><td><img src='figures/Light.Red.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Red</td><td>#F1A7BB</td><td><img src='figures/Pale.Red.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Dark.Orange</td><td>#A77011</td><td><img src='figures/Dark.Orange.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Orange</td><td>#E99F1F</td><td><img src='figures/Orange.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Orange</td><td>#F0BF6A</td><td><img src='figures/Light.Orange.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Orange</td><td>#F4CF90</td><td><img src='figures/Pale.Orange.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Yellow</td><td>#E8D206</td><td><img src='figures/Yellow.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Yellow</td><td>#FFE373</td><td><img src='figures/Light.Yellow.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Yellow</td><td>#FFF8DC</td><td><img src='figures/Pale.Yellow.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Dark.Green</td><td>#54711E</td><td><img src='figures/Dark.Green.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Green</td><td>#83B02F</td><td><img src='figures/Green.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Green</td><td>#ABD45E</td><td><img src='figures/Light.Green.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Green</td><td>#C4E18E</td><td><img src='figures/Pale.Green.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Dark.Blue</td><td>#004852</td><td><img src='figures/Dark.Blue.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Blue</td><td>#008C9E</td><td><img src='figures/Blue.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Blue</td><td>#1FE5FF</td><td><img src='figures/Light.Blue.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Blue</td><td>#85F1FF</td><td><img src='figures/Pale.Blue.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Dark.Purple</td><td>#4E2183</td><td><img src='figures/Dark.Purple.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Purple</td><td>#743496</td><td><img src='figures/Purple.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Purple</td><td>#A06CDA</td><td><img src='figures/Light.Purple.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Purple</td><td>#CAADEB</td><td><img src='figures/Pale.Purple.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Dark.Grey</td><td>#403A3F</td><td><img src='figures/Dark.Grey.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Grey</td><td>#6F646C</td><td><img src='figures/Grey.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Light.Grey</td><td>#9E949B</td><td><img src='figures/Light.Grey.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
<tr><td>Pale.Grey</td><td>#CFC9CD</td><td><img src='figures/Pale.Grey.png' style='width:1em; height:1em; border:1px solid #000;'></td></tr>
</table>
}
\if{latex}{
This palette consists of named hex colors. Each color's name (e.g., \code{Dark.Red}) is available as an exported object.

Swatch images are embedded below (not selectable):

\out{
\\renewcommand{\\arraystretch}{1.4}
\\begin{tabular}{@{}l l c l l c l l@{}}
\\textbf{Color} & \\textbf{Swatch} & & \\textbf{Color} & \\textbf{Swatch} & & \\textbf{Color} & \\textbf{Swatch} \\\\
\\hline
& & & & & & & \\\\
\\raisebox{0.75em}{Deep.Red}     & \\includegraphics[width=2em]{Deep.Red.png}     && \\raisebox{0.75em}{Deep.Green}   & \\includegraphics[width=2em]{Deep.Green.png}     && \\raisebox{0.75em}{Deep.Grey}    & \\includegraphics[width=2em]{Deep.Grey.png} \\\\
\\raisebox{0.75em}{Dark.Red}     & \\includegraphics[width=2em]{Dark.Red.png}     && \\raisebox{0.75em}{Dark.Green}   & \\includegraphics[width=2em]{Dark.Green.png}     && \\raisebox{0.75em}{Dark.Grey}    & \\includegraphics[width=2em]{Dark.Grey.png} \\\\
\\raisebox{0.75em}{Red}          & \\includegraphics[width=2em]{Red.png}          && \\raisebox{0.75em}{Green}        & \\includegraphics[width=2em]{Green.png}          && \\raisebox{0.75em}{Grey}         & \\includegraphics[width=2em]{Grey.png} \\\\
\\raisebox{0.75em}{Light.Red}    & \\includegraphics[width=2em]{Light.Red.png}    && \\raisebox{0.75em}{Light.Green}  & \\includegraphics[width=2em]{Light.Green.png}    && \\raisebox{0.75em}{Light.Grey}   & \\includegraphics[width=2em]{Light.Grey.png} \\\\
\\raisebox{0.75em}{Pale.Red}     & \\includegraphics[width=2em]{Pale.Red.png}     && \\raisebox{0.75em}{Pale.Green}   & \\includegraphics[width=2em]{Pale.Green.png}     && \\raisebox{0.75em}{Pale.Grey}    & \\includegraphics[width=2em]{Pale.Grey.png} \\\\
\\raisebox{0.75em}{Deep.Orange}  & \\includegraphics[width=2em]{Deep.Orange.png}  && \\raisebox{0.75em}{Deep.Blue}    & \\includegraphics[width=2em]{Deep.Blue.png}      &&              &                                   \\\\
\\raisebox{0.75em}{Dark.Orange}  & \\includegraphics[width=2em]{Dark.Orange.png}  && \\raisebox{0.75em}{Dark.Blue}    & \\includegraphics[width=2em]{Dark.Blue.png}      &&              &                                   \\\\
\\raisebox{0.75em}{Orange}       & \\includegraphics[width=2em]{Orange.png}       && \\raisebox{0.75em}{Blue}         & \\includegraphics[width=2em]{Blue.png}           &&              &                                   \\\\
\\raisebox{0.75em}{Light.Orange} & \\includegraphics[width=2em]{Light.Orange.png} && \\raisebox{0.75em}{Light.Blue}   & \\includegraphics[width=2em]{Light.Blue.png}     &&              &                                   \\\\
\\raisebox{0.75em}{Pale.Orange}  & \\includegraphics[width=2em]{Pale.Orange.png}  && \\raisebox{0.75em}{Pale.Blue}    & \\includegraphics[width=2em]{Pale.Blue.png}      &&              &                                   \\\\
\\raisebox{0.75em}{Deep.Yellow}  & \\includegraphics[width=2em]{Deep.Yellow.png}  && \\raisebox{0.75em}{Deep.Purple}  & \\includegraphics[width=2em]{Deep.Purple.png}    &&              &                                   \\\\
\\raisebox{0.75em}{Dark.Yellow}  & \\includegraphics[width=2em]{Dark.Yellow.png}  && \\raisebox{0.75em}{Dark.Purple}  & \\includegraphics[width=2em]{Dark.Purple.png}    &&              &                                   \\\\
\\raisebox{0.75em}{Yellow}       & \\includegraphics[width=2em]{Yellow.png}       && \\raisebox{0.75em}{Purple}       & \\includegraphics[width=2em]{Purple.png}         &&              &                                   \\\\
\\raisebox{0.75em}{Light.Yellow} & \\includegraphics[width=2em]{Light.Yellow.png} && \\raisebox{0.75em}{Light.Purple} & \\includegraphics[width=2em]{Light.Purple.png}   &&              &                                   \\\\
\\raisebox{0.75em}{Pale.Yellow}  & \\includegraphics[width=2em]{Pale.Yellow.png}  && \\raisebox{0.75em}{Pale.Purple}  & \\includegraphics[width=2em]{Pale.Purple.png}    &&              &                                   \\\\
& & & & & & & \\\\
\\end{tabular}
}

For the full list and hex codes, use \code{names(color.list)} or see \code{?color.list}.
}
}
\seealso{
\code{\link{color.list}}, \code{\link{color.ref}}
}
\keyword{datasets}
