% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact-matrix-utils.R
\name{impute_contact_ages}
\alias{impute_contact_ages}
\title{Impute contact ages}
\usage{
impute_contact_ages(contacts, estimate = c("mean", "sample", "missing"))
}
\arguments{
\item{contacts}{a survey data set of contacts}

\item{estimate}{if set to "mean" (default), contacts whose ages are given as
a range (in columns named "..._est_min" and "..._est_max") but not exactly
(in a column named "..._exact") will have their age set to the mid-point of
the range; if set to "sample", the age will be sampled from the range; if
set to "missing", age ranges will be treated as missing}
}
\value{
The contact data, potentially with contact ages imputed depending on the
\code{estimate} method and whether age columns are present in the data.
}
\description{
Imputes contact survey data, where variables are named:
"cnt_age_est_min" and "cnt_age_est_max". Uses mean imputation, sampling
(hot deck), or leaves them as missing. These are controlled by the
\code{estimate} argument.
}
\keyword{internal}
