% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexcel.R
\name{lexcelScores}
\alias{lexcelScores}
\alias{lexcelRanking}
\alias{dualLexcelRanking}
\title{Lexicographical Excellence}
\usage{
lexcelScores(powerRelation, elements = NULL)

lexcelRanking(powerRelation)

dualLexcelRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{PowerRelation} object created by \code{\link[=newPowerRelation]{newPowerRelation()}}}

\item{elements}{vector of elements of which to calculate their scores.
If \code{elements == NULL}, create vectors for all elements in \code{pr$elements}}
}
\value{
Score function returns a list of type \code{LexcelScores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified).
Each index contains a vector of length \code{powerRelation$equivalenceClasses}, the number of
times the given element appears in each equivalence class.

Ranking function returns corresponding \code{\link{SocialRankingSolution}} object.
}
\description{
Calculate the Lexicographical Excellence (or Lexcel) score.

\code{\link{lexcelRanking}} returns the corresponding ranking.

\code{\link{dualLexcelRanking}} uses the same score vectors but instead of rewarding
participation, it punishes mediocrity.
}
\details{
\loadmathjax
An equivalence class \mjeqn{\sum_i}{Sum_i} holds all coalitions
that are indifferent from one another. In a given power relation created with
\code{\link[=newPowerRelation]{newPowerRelation()}}, the equivalence classes are saved in \verb{$equivalenceClasses}.

E.g. for a power relation defined as
\mjeqn{123 \succ (12 \sim 13 \sim 1 \sim \emptyset) \succ (23 \sim 1 \sim 2)}{123 > (12 ~ 13 ~ 1) > (23 ~ 1 ~ 2)}
we would get the following equivalence classes:

\mjeqn{\sum_1 = \lbrace 123 \rbrace}{Sum_1 = \{123\}},
\mjeqn{\sum_2 = \lbrace 12, 13, 1, \emptyset \rbrace}{Sum_2 = \{12, 13, 1, empty set\}},
\mjeqn{\sum_3 = \lbrace 23, 1, 2 \rbrace}{Sum_3 = \{23, 1, 2\}}.

A Lexcel score for an element is a vector where
each index counts the number of times it appears in the
equivalence class. Here we would get:

\mjeqn{\textrm{lexcel}(1) = [ 1, 3, 1 ]}{lexcel(1) = \link{1,3,1}},
\mjeqn{\textrm{lexcel}(2) = [1, 1, 2 ]}{lexcel(2) = \link{1,1,2}},
\mjeqn{\textrm{lexcel}(3) = [1, 1, 1 ]}{lexcel(3) = \link{1,1,1}}.
}
\section{Lexcel Ranking}{


The most "excellent contribution" of an element determines its ranking against the other elements.
Given two Lexcel score vectors \mjeqn{\textrm{Score}(i)}{Score(i)}
and \mjeqn{\textrm{Score}(j)}{Score(j)}, the first index \mjseqn{x} where
\mjeqn{\textrm{Score}(i)_x \neq \textrm{Score}(j)_x}{Score(i)_x != Score(j)_x}
determines which element should be ranked higher.

From the previous example this would be \mjseqn{1 > 2 > 3}, because:

\mjeqn{\textrm{Score}(1)_2 = 3 > \textrm{Score}(2)_2 = \textrm{Score}(3)_2 = 1}{Score(1)_2 = 3 > Score(2) = Score(3) = 1},
\mjeqn{\textrm{Score}(2)_3 = 2 > \textrm{Score}(3)_3 = 1}{Score(2)_3 = 2 > Score(3)_3 = 1}.
}

\section{Dual Lexcel Ranking}{


The dual lexcel works in reverse order and, instead of rewarding high
scores, punishes mediocrity. In that case we get \mjseqn{3 > 1 > 2}
because:

\mjeqn{\textrm{Score}(3)_3 < \textrm{Score}(2)_3}{Score(3)_3 < Score(2)_3} and
\mjeqn{\textrm{Score}(3)_2 < \textrm{Score}(1)_2}{Score(3)_2 < Score(1)_3},
\mjeqn{\textrm{Score}(1)_3 < \textrm{Score}(2)_3}{Score(1)_3 < Score(2)_3}.
}

\examples{
# note that the coalition {1} appears twice
# 123 > 12 ~ 13 ~ 1 ~ {} > 23 ~ 1 ~ 2
# E = {123} > {12, 13, 1, {}} > {23, 1, 2}
pr <- suppressWarnings(newPowerRelation(
  c(1,2,3),
  ">", c(1,2), "~", c(1,3), "~", 1, "~", c(),
  ">", c(2,3), "~", 1, "~", 2
))

# lexcel scores for all elements
# `1` = c(1, 3, 1)
# `2` = c(1, 1, 2)
# `3` = c(1, 1, 1)
lexcelScores(pr)

# lexcel scores for a subset of all elements
lexcelScores(pr, c(1, 3))
lexcelScores(pr, 2)

# 1 > 2 > 3
lexcelRanking(pr)

# 3 > 1 > 2
dualLexcelRanking(pr)

}
\references{
\insertRef{2019Lexcel}{socialranking}

\insertRef{2021Lexcel}{socialranking}

\insertRef{2021AntiLexcel}{socialranking}
}
\seealso{
Other score vector functions: 
\code{\link{copelandScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{score vector functions}
