% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_bulk_update.R
\name{db_bulk_update}
\alias{db_bulk_update}
\title{Create documents via the bulk API}
\usage{
db_bulk_update(cushion, dbname, doc, docid = NULL, how = "rows",
  as = "list", ...)
}
\arguments{
\item{cushion}{A \code{Cushion} object. Required.}

\item{dbname}{(character) Database name. Required.}

\item{doc}{For now, a data.frame only. Required.}

\item{docid}{Document IDs, ignored for now, eventually, you can pass in a
list, or vector to be the ids for each document created. Has to be the same
length as the number of documents.}

\item{how}{(character) One of rows (default) or columns. If rows, each row
becomes a separate document; if columns, each column becomes a separate
document.}

\item{as}{(character) One of list (default) or json}

\item{...}{Curl args passed on to one of the HTTP verbs (e.g,.
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, \code{\link[httr]{PUT}},
etc.)}
}
\value{
Either a list or json (depending on \code{as} parameter), with
each element an array of key:value pairs:
\itemize{
 \item ok - whether creation was successful
 \item id - the document id
 \item rev - the revision id
}
}
\description{
Create documents via the bulk API
}
\examples{
\dontrun{
# initialize a couchdb connection
(x <- Cushion$new())

row.names(mtcars) <- NULL

if ("bulktest" \%in\% db_list(x)) {
  invisible(db_delete(x, dbname="bulktest"))
}
db_create(x, dbname="bulktest")
db_bulk_create(x, mtcars, dbname="bulktest")

# modify mtcars
mtcars$letter <- sample(letters, NROW(mtcars), replace = TRUE)
db_bulk_update(x, "bulktest", mtcars)

# change again
mtcars$num <- 89
db_bulk_update(x, "bulktest", mtcars)
}
}

