% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/hardclasses.R
\name{hardclasses}
\alias{hardclasses}
\alias{harden}
\title{Convert to hard class labels}
\usage{
hardclasses(x, classdim = 2L, soft.name = NA, tol = 1e-05, drop = TRUE)

harden(x, classdim = 2L, tol = 1e-06, closed = TRUE)
}
\arguments{
\item{x}{matrix or array holding the class memberships}

\item{classdim}{dimension that holds the classes, default columns}

\item{soft.name}{level for soft samples}

\item{tol}{tolerance: samples with membership >= 1 - tol are considered to be hard samples of the
respective class.}

\item{drop}{see \code{\link[arrayhelpers]{drop1d}}}

\item{closed}{logical indicating whether the system should be treated as closed-world (i.e. all
memberships add to 1)}
}
\value{
factor array of shape \code{dim (x) [-classdim]}
}
\description{
\code{hardclasses} converts the soft class labels in \code{x} into a factor with hard class memberships and
\code{NA} for soft samples.
}
\details{
\code{harden} hardens the soft
}
\examples{
softclassval:::pred
harden (softclassval:::pred)
harden (softclassval:::pred, closed = FALSE)

## classical threshold at 0.5
harden (softclassval:::pred, tol = 0.5)

## grey zone: NA for memberships between 0.25 and 0.75
harden (softclassval:::pred, tol = 0.25)

## threshold at 0.7 = 0.5 + 0.2:
harden (softclassval:::pred - 0.2, tol = 0.5)
harden (softclassval:::pred - 0.2, tol = 0.5, closed = FALSE)
}
\author{
Claudia Beleites
}
\seealso{
\code{\link[softclassval]{factor2matrix}} for the inverse
}

